/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.entity.ai.brain.tasks;

import com.google.common.collect.ImmutableMap;
import fabric.net.mca.Config;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.ai.ConversationManager;
import fabric.net.mca.entity.ai.Memories;
import fabric.net.mca.entity.ai.Relationship;
import fabric.net.mca.entity.ai.relationship.CompassionateEntity;
import fabric.net.mca.server.world.data.PlayerSaveData;
import fabric.net.mca.server.world.data.Village;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4097;

public class GreetPlayerTask
extends class_4097<VillagerEntityMCA> {
    private static final int MAX_COOLDOWN = 100;
    private int cooldown = 0;

    public GreetPlayerTask() {
        super((Map)ImmutableMap.of(), 0);
    }

    protected boolean shouldRun(class_3218 world, VillagerEntityMCA entity) {
        --this.cooldown;
        return this.cooldown < 0;
    }

    protected void run(class_3218 world, VillagerEntityMCA villager, long time) {
        this.cooldown = 100;
        GreetPlayerTask.getPlayer(villager).ifPresent(player -> {
            Memories memories = villager.getVillagerBrain().getMemoriesForPlayer((class_1657)player);
            int day = (int)(villager.method_37908().method_8532() / 24000L);
            memories.setLastSeen(day);
            String phrase = memories.getHearts() < 0 ? "welcomeFoe" : "welcome";
            villager.conversationManager.addMessage(new ConversationManager.PhraseText((class_1297)player, phrase));
        });
    }

    private static Optional<? extends class_1657> getPlayer(VillagerEntityMCA villager) {
        return ((class_3218)villager.method_37908()).method_18456().stream().filter(p -> GreetPlayerTask.isWithinSeeRange(villager, (class_1657)p)).filter(p -> GreetPlayerTask.shouldGreet(villager, p)).findFirst();
    }

    private static boolean shouldGreet(VillagerEntityMCA villager, class_3222 player) {
        Optional<Integer> id = PlayerSaveData.get(player).getLastSeenVillageId();
        Optional<Village> village = villager.getResidency().getHomeVillage();
        if (id.isPresent() && village.isPresent() && id.get().intValue() == village.get().getId()) {
            Memories memories = villager.getVillagerBrain().getMemoriesForPlayer((class_1657)player);
            int day = (int)(villager.method_37908().method_8532() / 24000L);
            if (Relationship.IS_MARRIED.test((CompassionateEntity<?>)villager, (class_1297)player) || Relationship.IS_RELATIVE.test((CompassionateEntity<?>)villager, (class_1297)player) || Math.abs(memories.getHearts()) >= Config.getInstance().greetHeartsThreshold) {
                long diff = (long)day - memories.getLastSeen();
                if (diff > (long)Config.getInstance().greetAfterDays && memories.getLastSeen() > 0L) {
                    return true;
                }
                if (diff > 0L) {
                    memories.setLastSeen(day);
                }
            } else {
                memories.setLastSeen(day);
            }
        }
        return false;
    }

    private static boolean isWithinSeeRange(VillagerEntityMCA villager, class_1657 player) {
        return villager.method_24515().method_19771((class_2382)player.method_24515(), 32.0);
    }
}

