/*
 * Decompiled with CFR 0.152.
 */
package fabric.net.mca.entity.ai;

import fabric.net.mca.ClientProxy;
import fabric.net.mca.Config;
import fabric.net.mca.MCA;
import fabric.net.mca.cobalt.network.NetworkHandler;
import fabric.net.mca.entity.EntityWrapper;
import fabric.net.mca.entity.VillagerEntityMCA;
import fabric.net.mca.entity.ai.DialogueType;
import fabric.net.mca.network.s2c.VillagerMessage;
import fabric.net.mca.resources.API;
import fabric.net.mca.server.world.data.FamilyTree;
import fabric.net.mca.server.world.data.FamilyTreeNode;
import fabric.net.mca.server.world.data.PlayerSaveData;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_4051;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public interface Messenger
extends EntityWrapper {
    public static final class_4051 CAN_RECEIVE = class_4051.method_36626();

    default public boolean isSpeechImpaired() {
        return false;
    }

    default public boolean isToYoungToSpeak() {
        return false;
    }

    default public void playSpeechEffect() {
    }

    default public DialogueType getDialogueType(class_1657 receiver) {
        return DialogueType.UNASSIGNED;
    }

    default public class_5250 getTranslatable(class_1657 target, String phraseId, Object ... params) {
        class_1308 class_13082;
        String targetName;
        Object genderString = "";
        class_1937 class_19372 = target.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 world = (class_3218)class_19372;
            targetName = FamilyTree.get(world).getOrEmpty(target.method_5667()).map(FamilyTreeNode::getName).filter(n -> !MCA.isBlankString(n)).orElse(target.method_5477().getString());
            genderString = "#G" + PlayerSaveData.get((class_3222)target).getGender().name().toLowerCase(Locale.ROOT) + ".";
        } else {
            targetName = target.method_5477().getString();
        }
        Object[] newParams = new Object[params.length + 1];
        System.arraycopy(params, 0, newParams, 1, params.length);
        newParams[0] = targetName;
        Object professionString = "";
        if (!this.asEntity().method_6109() && (class_13082 = this.asEntity()) instanceof VillagerEntityMCA) {
            VillagerEntityMCA v = (VillagerEntityMCA)class_13082;
            professionString = "#P" + class_7923.field_41195.method_10221((Object)v.getProfession()).method_12832() + ".";
        }
        Object personalityString = "";
        class_1308 class_13083 = this.asEntity();
        if (class_13083 instanceof VillagerEntityMCA) {
            VillagerEntityMCA v = (VillagerEntityMCA)class_13083;
            personalityString = "#E" + v.getVillagerBrain().getPersonality().name() + ".";
        }
        return class_2561.method_43469((String)((String)genderString + (String)personalityString + (String)professionString + "#T" + this.getDialogueType(target).name() + "." + phraseId), (Object[])newParams);
    }

    default public void sendChatToAllAround(class_5250 phrase) {
        for (class_1657 player : this.asEntity().method_37908().method_18464(CAN_RECEIVE, (class_1309)this.asEntity(), this.asEntity().method_5829().method_1014(20.0))) {
            float dist = player.method_5739((class_1297)this.asEntity());
            this.sendChatMessage(phrase.method_27692(dist < 10.0f ? class_124.field_1068 : class_124.field_1080), (class_1297)player);
        }
    }

    default public void sendChatToAllAround(String phrase, Object ... params) {
        for (class_1657 player : this.asEntity().method_37908().method_18464(CAN_RECEIVE, (class_1309)this.asEntity(), this.asEntity().method_5829().method_1014(20.0))) {
            float dist = player.method_5739((class_1297)this.asEntity());
            this.sendChatMessage(this.getTranslatable(player, phrase, params).method_27692(dist < 10.0f ? class_124.field_1068 : class_124.field_1080), (class_1297)player);
        }
    }

    default public void sendChatMessage(class_1657 target, String phraseId, Object ... params) {
        this.sendChatMessage(this.getTranslatable(target, phraseId, params), (class_1297)target);
    }

    default public class_5250 transformMessage(class_5250 message) {
        if (this.isSpeechImpaired()) {
            return class_2561.method_43470((String)API.getRandomSentence("zombie", message.getString()));
        }
        if (this.isToYoungToSpeak()) {
            return class_2561.method_43470((String)API.getRandomSentence("baby", message.getString()));
        }
        return message;
    }

    default public class_5250 sendChatMessage(class_5250 message, class_1297 receiver) {
        message = this.transformMessage(message);
        class_5250 prefix = class_2561.method_43470((String)Config.getInstance().villagerChatPrefix).method_10852(this.asEntity().method_5476()).method_27693(": ");
        VillagerMessage msg = new VillagerMessage(prefix, message, this.asEntity().method_5667());
        if (receiver instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)receiver;
            NetworkHandler.sendToPlayer(msg, serverPlayer);
        } else {
            ClientProxy.getNetworkHandler().handleVillagerMessage(msg);
        }
        this.playSpeechEffect();
        return prefix.method_10852((class_2561)message);
    }

    default public void sendEventMessage(class_2561 message, class_1657 receiver) {
        receiver.method_7353(message, true);
    }

    default public void sendEventMessage(class_2561 message) {
        if (!(this instanceof class_1297)) {
            return;
        }
        Messenger.sendEventMessage(((class_1297)this).method_37908(), message);
    }

    public static void sendEventMessage(class_1937 world, class_2561 message) {
        world.method_18456().forEach(player -> player.method_7353(message, true));
    }
}

