/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexthe668.domesticationinnovation.client.particle;

import com.github.alexthe668.domesticationinnovation.DomesticationMod;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.Random;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Wolf;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeRenderTypes;

public class ParticleIntimidation
extends Particle {
    private float xRot;
    private float yRot;
    private int entityId;

    ParticleIntimidation(ClientLevel lvl, double x, double y, double z, int entityId, float xRot, float yRot) {
        super(lvl, x, y, z);
        this.m_107250_(1.0f, 1.0f);
        this.f_107226_ = 0.0f;
        this.f_107225_ = 22 + new Random().nextInt(7);
        this.entityId = entityId;
        this.xRot = xRot;
        this.yRot = yRot;
    }

    public ParticleRenderType m_7556_() {
        return ParticleRenderType.f_107433_;
    }

    public void m_5744_(VertexConsumer vertexConsumer, Camera camera, float partialTick) {
        Entity entity = Minecraft.m_91087_().f_91073_.m_6815_(this.entityId);
        if (entity != null) {
            Vec3 vec3 = camera.m_90583_();
            PoseStack posestack = new PoseStack();
            MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
            float f = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107209_, (double)this.f_107212_) - vec3.m_7096_());
            float f1 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107210_, (double)this.f_107213_) - vec3.m_7098_());
            float f2 = (float)(Mth.m_14139_((double)partialTick, (double)this.f_107211_, (double)this.f_107214_) - vec3.m_7094_());
            float lerpAge = (float)this.f_107224_ + partialTick;
            float ageProgress = lerpAge / (float)this.f_107225_;
            float fadeTime = 0.15f;
            float fadeIn = Math.min(ageProgress, fadeTime) / fadeTime;
            float fadeOut = Mth.m_14036_((float)(ageProgress - (1.0f - fadeTime)), (float)0.0f, (float)fadeTime) / fadeTime;
            float up = 0.2f + (2.0f + entity.m_20206_()) * fadeIn + (float)Math.sin(lerpAge * 0.3f) * 0.03f;
            float down = -3.0f * fadeOut;
            float scale = (fadeIn - fadeOut) * 1.5f;
            posestack.m_85836_();
            posestack.m_252880_(f, f1 + (up + down), f2);
            posestack.m_252781_(Axis.f_252529_.m_252977_(180.0f));
            posestack.m_252781_(Axis.f_252436_.m_252977_(this.yRot));
            posestack.m_85841_(scale, scale, scale);
            this.renderEntity(entity, 0.0, 0.0, 0.0, scale, partialTick, posestack, (MultiBufferSource)multibuffersource$buffersource, this.m_6355_(partialTick));
            multibuffersource$buffersource.m_109911_();
            posestack.m_85849_();
        }
    }

    public <E extends Entity> void renderEntity(E entityIn, double x, double y, double z, float scale, float partialTicks, PoseStack matrixStack, MultiBufferSource bufferIn, int packedLight) {
        EntityRenderer render = null;
        EntityRenderDispatcher manager = Minecraft.m_91087_().m_91290_();
        try {
            render = manager.m_114382_(entityIn);
            if (render instanceof LivingEntityRenderer) {
                boolean prevSit;
                LivingEntityRenderer livingEntityRenderer = (LivingEntityRenderer)render;
                EntityModel model = livingEntityRenderer.m_7200_();
                ResourceLocation tex = livingEntityRenderer.m_5478_(entityIn);
                float alpha = Math.min(scale, 1.0f) * 0.5f;
                boolean bl = prevSit = entityIn instanceof TamableAnimal && ((TamableAnimal)entityIn).m_21825_();
                if (entityIn instanceof TamableAnimal) {
                    ((TamableAnimal)entityIn).m_21837_(false);
                }
                float bob = entityIn instanceof Wolf ? ((Wolf)entityIn).m_30427_() : (float)entityIn.f_19797_ + partialTicks;
                model.m_6839_(entityIn, 1.0f, 0.0f, partialTicks);
                model.m_6973_(entityIn, 0.0f, 0.0f, bob, 0.0f, this.xRot);
                model.m_7695_(matrixStack, bufferIn.m_6299_(ForgeRenderTypes.getItemLayeredTranslucent((ResourceLocation)tex)), packedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, alpha);
                if (entityIn instanceof TamableAnimal) {
                    ((TamableAnimal)entityIn).m_21837_(prevSit);
                }
            }
        }
        catch (Throwable throwable3) {
            DomesticationMod.LOGGER.warn("could not render intimidating effect");
            this.m_107274_();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Particle createParticle(SimpleParticleType typeIn, ClientLevel worldIn, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            return new ParticleIntimidation(worldIn, x, y, z, (int)xSpeed, (float)ySpeed, (float)zSpeed);
        }
    }
}

