/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.network.c2s;

import net.conczin.immersive_furniture.Common;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.data.FurnitureDataManager;
import net.conczin.immersive_furniture.network.ImmersivePayload;
import net.conczin.immersive_furniture.network.Network;
import net.conczin.immersive_furniture.network.s2c.FurnitureDataResponse;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public record FurnitureDataRequest(String hash) implements ImmersivePayload
{
    public FurnitureDataRequest(FriendlyByteBuf b) {
        this(b.m_130277_());
    }

    @Override
    public void encode(FriendlyByteBuf b) {
        b.m_130070_(this.hash);
    }

    @Override
    public void handle(Player e) {
        if (e instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)e;
            FurnitureData data = FurnitureDataManager.getHashData(this.hash);
            if (data != null) {
                Network.sendToPlayer(new FurnitureDataResponse(this.hash, data), sp);
            } else {
                Common.logger.warn("Client requested missing furniture data for hash {}.", (Object)this.hash);
            }
        }
    }
}

