/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.network.c2s;

import net.conczin.immersive_furniture.Sounds;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.conczin.immersive_furniture.item.FurnitureItem;
import net.conczin.immersive_furniture.item.Items;
import net.conczin.immersive_furniture.network.ImmersivePayload;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public record CraftRequest(FurnitureData data, boolean shift) implements ImmersivePayload
{
    private static long lastSoundTime = 0L;

    public CraftRequest(FriendlyByteBuf b) {
        this(new FurnitureData(Utils.fromBytes(b.m_130052_())), b.readBoolean());
    }

    @Override
    public void encode(FriendlyByteBuf b) {
        CompoundTag tag = this.data.toTag();
        b.m_130087_(Utils.toBytes(tag));
        b.writeBoolean(this.shift);
    }

    @Override
    public void handle(Player e) {
        if (!CraftRequest.isValid(this.data)) {
            return;
        }
        int cost = this.data.getCost();
        int available = this.getResources(e);
        if (e.m_7500_()) {
            available = Integer.MAX_VALUE;
        }
        int amount = 1;
        if (this.shift) {
            amount = Math.min(available / cost, 64);
        }
        if (amount == 0) {
            return;
        }
        if (available < cost * amount) {
            e.m_5661_((Component)Component.m_237115_((String)"immersive_furniture.not_enough_material"), true);
        } else {
            if (!e.m_7500_()) {
                this.useResources(e, amount * cost);
            }
            this.giveFurniture(e, this.data, amount);
            long time = System.currentTimeMillis();
            float volume = Math.min(1.0f, (float)Math.abs(lastSoundTime - time) / 1000.0f);
            if (volume > 0.05f) {
                lastSoundTime = time;
                e.m_9236_().m_5594_(null, e.m_20097_(), Sounds.ASSEMBLE, SoundSource.BLOCKS, (e.m_217043_().m_188501_() * 0.2f + 0.8f) * volume, e.m_217043_().m_188501_() * 0.5f + 0.75f);
            }
        }
    }

    private static boolean isValid(FurnitureData data) {
        return data != null;
    }

    private static boolean isValidItem(ItemStack stack) {
        return stack.m_41720_() == Items.CRAFTING_MATERIAL;
    }

    private int getResources(Player e) {
        int amount = 0;
        Inventory inventory = e.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!CraftRequest.isValidItem(stack)) continue;
            amount += stack.m_41613_();
        }
        return amount;
    }

    private void useResources(Player e, int amount) {
        Inventory inventory = e.m_150109_();
        for (int i = 0; i < inventory.m_6643_(); ++i) {
            ItemStack stack = inventory.m_8020_(i);
            if (!CraftRequest.isValidItem(stack)) continue;
            if (stack.m_41613_() >= amount) {
                stack.m_41774_(amount);
                return;
            }
            amount -= stack.m_41613_();
            inventory.m_6836_(i, ItemStack.f_41583_);
        }
    }

    private void giveFurniture(Player e, FurnitureData data, int count) {
        ItemStack stack = new ItemStack((ItemLike)Items.FURNITURE, count);
        FurnitureItem.setData(stack, data);
        if (!e.m_150109_().m_36054_(stack)) {
            e.m_36176_(stack, false);
        }
    }
}

