/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.network;

import java.util.function.Function;
import net.conczin.immersive_furniture.network.ImmersivePayload;
import net.conczin.immersive_furniture.network.c2s.CraftRequest;
import net.conczin.immersive_furniture.network.c2s.FurnitureDataRequest;
import net.conczin.immersive_furniture.network.s2c.FurnitureDataResponse;
import net.conczin.immersive_furniture.network.s2c.FurnitureInteractMessage;
import net.conczin.immersive_furniture.network.s2c.FurnitureRegistryMessage;
import net.conczin.immersive_furniture.network.s2c.PoseOffsetMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public class Network {
    private static Sender sender;
    private static ClientSender clientSender;

    public static void registerSender(Sender sender) {
        Network.sender = sender;
    }

    public static void registerClientSender(ClientSender clientSender) {
        Network.clientSender = clientSender;
    }

    public static void sendToServer(ImmersivePayload payload) {
        clientSender.sendToServer(payload);
    }

    public static void sendToPlayer(ImmersivePayload payload, ServerPlayer player) {
        sender.sendToPlayer(payload, player);
    }

    public static void sendToAllPlayers(MinecraftServer server, ImmersivePayload payload) {
        server.m_6846_().m_11314_().forEach(p -> Network.sendToPlayer(payload, p));
    }

    public static void register(Registrar c) {
        c.register(CraftRequest.class, CraftRequest::new);
        c.register(FurnitureDataRequest.class, FurnitureDataRequest::new);
        c.register(FurnitureDataResponse.class, FurnitureDataResponse::new);
        c.register(FurnitureInteractMessage.class, FurnitureInteractMessage::new);
        c.register(FurnitureRegistryMessage.class, FurnitureRegistryMessage::new);
        c.register(PoseOffsetMessage.class, PoseOffsetMessage::new);
    }

    public static interface Sender {
        public void sendToPlayer(ImmersivePayload var1, ServerPlayer var2);
    }

    public static interface ClientSender {
        public void sendToServer(ImmersivePayload var1);
    }

    public static interface Registrar {
        public <T extends ImmersivePayload> void register(Class<T> var1, Function<FriendlyByteBuf, T> var2);
    }
}

