/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.widgets;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.BufferUploader;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexFormat;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationScreen;
import net.conczin.immersive_furniture.client.gui.widgets.StateImageButton;
import net.conczin.immersive_furniture.client.model.MaterialSource;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;

public class MaterialButton
extends StateImageButton {
    MaterialSource material;

    public MaterialButton(int x, int y, int width, int height, int xTexStart, int yTexStart, Button.OnPress onPress) {
        super(x, y, width, height, xTexStart, yTexStart, ArtisansWorkstationScreen.TEXTURE, 256, 256, onPress, (Component)Component.m_237113_((String)""));
    }

    public MaterialSource getMaterial() {
        return this.material;
    }

    public void setMaterial(MaterialSource material) {
        this.material = material;
        if (material != null) {
            Component name = material.name();
            this.m_93666_(name);
            MutableComponent namespaceTooltip = Component.m_237113_((String)Utils.capitalize(material.location().m_135827_())).m_130940_(ChatFormatting.GRAY);
            this.m_257544_(Tooltip.m_257550_((Component)name.m_6881_().m_130946_("\n").m_7220_((Component)namespaceTooltip)));
        } else {
            this.m_93666_((Component)Component.m_237113_((String)""));
            this.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"")));
        }
    }

    public void m_87963_(GuiGraphics graphics, int mouseX, int mouseY, float partialTick) {
        if (this.material == null) {
            return;
        }
        super.m_87963_(graphics, mouseX, mouseY, partialTick);
        TextureAtlasSprite up = this.material.up().sprite();
        TextureAtlasSprite north = this.material.north().sprite();
        TextureAtlasSprite east = this.material.east().sprite();
        float size = (float)this.f_93618_ * 0.4f * (mouseX > this.m_252754_() && mouseX < this.m_252754_() + this.f_93618_ && mouseY > this.m_252907_() && mouseY < this.m_252907_() + this.f_93619_ ? 1.1f : 1.0f);
        float x = (float)this.m_252754_() + (float)this.f_93618_ / 2.0f;
        float y = (float)this.m_252907_() + (float)this.f_93619_ / 2.0f - size / 4.0f * 2.5f;
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)up.m_247685_());
        RenderSystem.setShader(GameRenderer::m_172814_);
        Matrix4f matrix4f = graphics.m_280168_().m_85850_().m_252922_();
        BufferBuilder bufferBuilder = Tesselator.m_85913_().m_85915_();
        bufferBuilder.m_166779_(VertexFormat.Mode.QUADS, DefaultVertexFormat.f_85818_);
        float lx = x - size;
        float rx = x + size;
        float py = y - size / 2.0f;
        float cy = y + size / 2.0f;
        float by = y + size / 4.0f * 5.0f;
        float ry = y + size / 4.0f * 7.0f;
        bufferBuilder.m_252986_(matrix4f, x, py, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(up.m_118409_(), up.m_118412_()).m_5752_();
        bufferBuilder.m_252986_(matrix4f, lx, y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(up.m_118410_(), up.m_118412_()).m_5752_();
        bufferBuilder.m_252986_(matrix4f, x, cy, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(up.m_118410_(), up.m_118411_()).m_5752_();
        bufferBuilder.m_252986_(matrix4f, rx, y, 0.0f).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(up.m_118409_(), up.m_118411_()).m_5752_();
        float ng = 0.8f;
        bufferBuilder.m_252986_(matrix4f, rx, y, 0.0f).m_85950_(ng, ng, ng, 1.0f).m_7421_(north.m_118410_(), north.m_118411_()).m_5752_();
        bufferBuilder.m_252986_(matrix4f, x, cy, 0.0f).m_85950_(ng, ng, ng, 1.0f).m_7421_(north.m_118409_(), north.m_118411_()).m_5752_();
        bufferBuilder.m_252986_(matrix4f, x, ry, 0.0f).m_85950_(ng, ng, ng, 1.0f).m_7421_(north.m_118409_(), north.m_118412_()).m_5752_();
        bufferBuilder.m_252986_(matrix4f, rx, by, 0.0f).m_85950_(ng, ng, ng, 1.0f).m_7421_(north.m_118410_(), north.m_118412_()).m_5752_();
        float eg = 0.6f;
        bufferBuilder.m_252986_(matrix4f, x, cy, 0.0f).m_85950_(eg, eg, eg, 1.0f).m_7421_(east.m_118410_(), east.m_118411_()).m_5752_();
        bufferBuilder.m_252986_(matrix4f, lx, y, 0.0f).m_85950_(eg, eg, eg, 1.0f).m_7421_(east.m_118409_(), east.m_118411_()).m_5752_();
        bufferBuilder.m_252986_(matrix4f, lx, by, 0.0f).m_85950_(eg, eg, eg, 1.0f).m_7421_(east.m_118409_(), east.m_118412_()).m_5752_();
        bufferBuilder.m_252986_(matrix4f, x, ry, 0.0f).m_85950_(eg, eg, eg, 1.0f).m_7421_(east.m_118410_(), east.m_118412_()).m_5752_();
        BufferUploader.m_231202_((BufferBuilder.RenderedBuffer)bufferBuilder.m_231175_());
    }
}

