/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture.client.gui.components;

import java.util.LinkedList;
import java.util.List;
import net.conczin.immersive_furniture.client.gui.ArtisansWorkstationEditorScreen;
import net.conczin.immersive_furniture.client.gui.components.ListComponent;
import net.conczin.immersive_furniture.utils.Utils;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ParticlesComponent
extends ListComponent {
    static final int PAGE_SIZE = 7;
    List<ResourceLocation> allLocations = new LinkedList<ResourceLocation>();
    List<ResourceLocation> locations = new LinkedList<ResourceLocation>();
    List<Button> buttons = new LinkedList<Button>();

    public ParticlesComponent(ArtisansWorkstationEditorScreen screen) {
        super(screen);
    }

    @Override
    public void init(int leftPos, int topPos, int width, int height) {
        if (this.screen.selectedElements.isEmpty()) {
            return;
        }
        this.buttons.clear();
        int y = topPos + 23;
        int i = 0;
        while (i < 7) {
            int finalI = i++;
            Button button = Button.m_253074_((Component)Component.m_237113_((String)""), b -> {
                if (finalI >= this.locations.size()) {
                    return;
                }
                this.screen.selectedElements.forEach(e -> {
                    e.particleEmitter.particle = this.locations.get(finalI);
                });
            }).m_252987_(leftPos + 5, y, width - 10, 18).m_253136_();
            this.screen.m_142416_(button);
            this.buttons.add(button);
            y += 19;
        }
        super.init(leftPos, topPos, width, height);
    }

    @Override
    int getPages() {
        return Math.max(0, (this.allLocations.size() - 1) / 7 + 1);
    }

    @Override
    void updateSearch() {
        this.allLocations = BuiltInRegistries.f_257034_.m_6566_().stream().filter(p -> Utils.search(this.searchBox.m_94155_(), p.toString())).sorted(ResourceLocation::compareTo).toList();
        this.page = Math.min(this.page, this.getPages() - 1);
        this.locations = this.allLocations.subList(this.page * 7, Math.min(this.page * 7 + 7, this.allLocations.size()));
        this.locations = this.allLocations.stream().skip((long)this.page * 7L).limit(7L).toList();
        for (int i = 0; i < this.buttons.size(); ++i) {
            Button button = this.buttons.get(i);
            if (i < this.locations.size()) {
                ResourceLocation location = this.locations.get(i);
                MutableComponent message = Component.m_237113_((String)Utils.capitalize(location));
                button.m_93666_((Component)message);
                MutableComponent namespaceTooltip = Component.m_237113_((String)Utils.capitalize(location.m_135827_())).m_130940_(ChatFormatting.GRAY);
                button.m_257544_(Tooltip.m_257550_((Component)message.m_6881_().m_130946_("\n").m_7220_((Component)namespaceTooltip)));
                button.f_93623_ = true;
                continue;
            }
            button.m_93666_((Component)Component.m_237113_((String)""));
            button.m_257544_(Tooltip.m_257550_((Component)Component.m_237113_((String)"")));
            button.f_93623_ = false;
        }
    }
}

