/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_furniture;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.conczin.immersive_furniture.block.BaseFurnitureBlock;
import net.conczin.immersive_furniture.block.FurnitureProxyBlock;
import net.conczin.immersive_furniture.data.FurnitureData;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;

public class InteractionManager {
    public static final InteractionManager INSTANCE = new InteractionManager();
    private final Map<UUID, Interaction> interactions = new ConcurrentHashMap<UUID, Interaction>();

    public void addInteraction(Entity entity, BlockPos pos, FurnitureData.PoseOffset offset) {
        this.interactions.put(entity.m_20148_(), new Interaction(pos, offset));
    }

    public Interaction getInteraction(LivingEntity entity) {
        Interaction interaction = this.interactions.get(entity.m_20148_());
        if (interaction != null) {
            Optional sleepingPos = entity.m_21257_();
            if (sleepingPos.isPresent() && !((BlockPos)sleepingPos.get()).equals((Object)interaction.pos)) {
                this.clearInteraction((Entity)entity);
                return null;
            }
            Level level = entity.m_9236_();
            if (InteractionManager.isFurnitureBed(level, interaction.pos())) {
                return interaction;
            }
            this.clearInteraction((Entity)entity);
        }
        return null;
    }

    public static boolean isFurnitureBed(Level level, BlockPos pos) {
        Block block = level.m_8055_(pos).m_60734_();
        return block instanceof BaseFurnitureBlock || block instanceof FurnitureProxyBlock;
    }

    public void clearInteraction(Entity entity) {
        this.interactions.remove(entity.m_20148_());
    }

    public void clearInteraction() {
        this.interactions.clear();
    }

    public record Interaction(BlockPos pos, FurnitureData.PoseOffset offset) {
    }
}

