/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.config;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import nx.pingwheel.common.CommonClient;
import nx.pingwheel.common.config.ConfigHandler;
import nx.pingwheel.common.config.IConfig;
import nx.pingwheel.common.config.PlayerInfoMode;
import nx.pingwheel.common.config.TeamColorMode;
import nx.pingwheel.common.core.GameContext;
import nx.pingwheel.common.network.UpdateChannelC2SPacket;
import nx.pingwheel.common.platform.IPlatformNetworkService;

public class ClientConfig
implements IConfig {
    int pingVolume = 100;
    int pingDuration = 7;
    int pingDistance = 2048;
    float correctionPeriod = 1.0f;
    boolean itemIconVisible = true;
    boolean directionIndicatorVisible = true;
    PlayerInfoMode playerInfoMode = PlayerInfoMode.HOLD;
    TeamColorMode teamColorMode = TeamColorMode.FULL;
    int pingSize = 100;
    String channel = "";
    Map<String, String> serverChannels = new HashMap<String, String>();
    int removeRadius = 10;
    int raycastDistance = 1024;
    int safeZoneLeft = 5;
    int safeZoneRight = 5;
    int safeZoneTop = 5;
    int safeZoneBottom = 60;
    public static final int TPS = 20;
    public static final int MAX_PING_DURATION = 60;
    public static final int MAX_PING_DISTANCE = 2048;
    public static final float MAX_CORRECTION_PERIOD = 5.0f;
    public static final int MAX_CHANNEL_LENGTH = 128;
    public static final ConfigHandler<ClientConfig> HANDLER = ConfigHandler.of(ClientConfig.class, ".json");

    public String getChannel() {
        Optional<String> ip = GameContext.getCurrentServerIp();
        if (ip.isPresent()) {
            return this.serverChannels.getOrDefault(ip.get(), "");
        }
        return this.channel;
    }

    public void setChannel(String newChannel) {
        Optional<String> ip = GameContext.getCurrentServerIp();
        if (ip.isPresent()) {
            this.serverChannels.put(ip.get(), newChannel);
        } else {
            this.channel = newChannel;
        }
    }

    @Override
    public void validate() {
        if (this.channel.length() > 128) {
            this.channel = this.channel.substring(0, 128);
        }
        for (Map.Entry<String, String> entry : this.serverChannels.entrySet()) {
            String channel = entry.getValue();
            if (channel.length() <= 128) continue;
            entry.setValue(channel.substring(0, 128));
        }
    }

    @Override
    public void onUpdate() {
        if (CommonClient.Game != null) {
            IPlatformNetworkService.INSTANCE.sendToServer(new UpdateChannelC2SPacket(this.getChannel()));
        }
    }

    public int getPingVolume() {
        return this.pingVolume;
    }

    public int getPingDuration() {
        return this.pingDuration;
    }

    public int getPingDistance() {
        return this.pingDistance;
    }

    public float getCorrectionPeriod() {
        return this.correctionPeriod;
    }

    public boolean isItemIconVisible() {
        return this.itemIconVisible;
    }

    public boolean isDirectionIndicatorVisible() {
        return this.directionIndicatorVisible;
    }

    public PlayerInfoMode getPlayerInfoMode() {
        return this.playerInfoMode;
    }

    public TeamColorMode getTeamColorMode() {
        return this.teamColorMode;
    }

    public int getPingSize() {
        return this.pingSize;
    }

    public Map<String, String> getServerChannels() {
        return this.serverChannels;
    }

    public int getRemoveRadius() {
        return this.removeRadius;
    }

    public int getRaycastDistance() {
        return this.raycastDistance;
    }

    public int getSafeZoneLeft() {
        return this.safeZoneLeft;
    }

    public int getSafeZoneRight() {
        return this.safeZoneRight;
    }

    public int getSafeZoneTop() {
        return this.safeZoneTop;
    }

    public int getSafeZoneBottom() {
        return this.safeZoneBottom;
    }

    public void setPingVolume(int pingVolume) {
        this.pingVolume = pingVolume;
    }

    public void setPingDuration(int pingDuration) {
        this.pingDuration = pingDuration;
    }

    public void setPingDistance(int pingDistance) {
        this.pingDistance = pingDistance;
    }

    public void setCorrectionPeriod(float correctionPeriod) {
        this.correctionPeriod = correctionPeriod;
    }

    public void setItemIconVisible(boolean itemIconVisible) {
        this.itemIconVisible = itemIconVisible;
    }

    public void setDirectionIndicatorVisible(boolean directionIndicatorVisible) {
        this.directionIndicatorVisible = directionIndicatorVisible;
    }

    public void setPlayerInfoMode(PlayerInfoMode playerInfoMode) {
        this.playerInfoMode = playerInfoMode;
    }

    public void setTeamColorMode(TeamColorMode teamColorMode) {
        this.teamColorMode = teamColorMode;
    }

    public void setPingSize(int pingSize) {
        this.pingSize = pingSize;
    }

    public void setServerChannels(Map<String, String> serverChannels) {
        this.serverChannels = serverChannels;
    }

    public void setRemoveRadius(int removeRadius) {
        this.removeRadius = removeRadius;
    }

    public void setRaycastDistance(int raycastDistance) {
        this.raycastDistance = raycastDistance;
    }

    public void setSafeZoneLeft(int safeZoneLeft) {
        this.safeZoneLeft = safeZoneLeft;
    }

    public void setSafeZoneRight(int safeZoneRight) {
        this.safeZoneRight = safeZoneRight;
    }

    public void setSafeZoneTop(int safeZoneTop) {
        this.safeZoneTop = safeZoneTop;
    }

    public void setSafeZoneBottom(int safeZoneBottom) {
        this.safeZoneBottom = safeZoneBottom;
    }

    public String toString() {
        return "ClientConfig(pingVolume=" + this.getPingVolume() + ", pingDuration=" + this.getPingDuration() + ", pingDistance=" + this.getPingDistance() + ", correctionPeriod=" + this.getCorrectionPeriod() + ", itemIconVisible=" + this.isItemIconVisible() + ", directionIndicatorVisible=" + this.isDirectionIndicatorVisible() + ", playerInfoMode=" + String.valueOf((Object)this.getPlayerInfoMode()) + ", teamColorMode=" + String.valueOf((Object)this.getTeamColorMode()) + ", pingSize=" + this.getPingSize() + ", channel=" + this.getChannel() + ", serverChannels=" + String.valueOf(this.getServerChannels()) + ", removeRadius=" + this.getRemoveRadius() + ", raycastDistance=" + this.getRaycastDistance() + ", safeZoneLeft=" + this.getSafeZoneLeft() + ", safeZoneRight=" + this.getSafeZoneRight() + ", safeZoneTop=" + this.getSafeZoneTop() + ", safeZoneBottom=" + this.getSafeZoneBottom() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ClientConfig)) {
            return false;
        }
        ClientConfig other = (ClientConfig)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPingVolume() != other.getPingVolume()) {
            return false;
        }
        if (this.getPingDuration() != other.getPingDuration()) {
            return false;
        }
        if (this.getPingDistance() != other.getPingDistance()) {
            return false;
        }
        if (Float.compare(this.getCorrectionPeriod(), other.getCorrectionPeriod()) != 0) {
            return false;
        }
        if (this.isItemIconVisible() != other.isItemIconVisible()) {
            return false;
        }
        if (this.isDirectionIndicatorVisible() != other.isDirectionIndicatorVisible()) {
            return false;
        }
        if (this.getPingSize() != other.getPingSize()) {
            return false;
        }
        if (this.getRemoveRadius() != other.getRemoveRadius()) {
            return false;
        }
        if (this.getRaycastDistance() != other.getRaycastDistance()) {
            return false;
        }
        if (this.getSafeZoneLeft() != other.getSafeZoneLeft()) {
            return false;
        }
        if (this.getSafeZoneRight() != other.getSafeZoneRight()) {
            return false;
        }
        if (this.getSafeZoneTop() != other.getSafeZoneTop()) {
            return false;
        }
        if (this.getSafeZoneBottom() != other.getSafeZoneBottom()) {
            return false;
        }
        PlayerInfoMode this$playerInfoMode = this.getPlayerInfoMode();
        PlayerInfoMode other$playerInfoMode = other.getPlayerInfoMode();
        if (this$playerInfoMode == null ? other$playerInfoMode != null : !((Object)((Object)this$playerInfoMode)).equals((Object)other$playerInfoMode)) {
            return false;
        }
        TeamColorMode this$teamColorMode = this.getTeamColorMode();
        TeamColorMode other$teamColorMode = other.getTeamColorMode();
        if (this$teamColorMode == null ? other$teamColorMode != null : !((Object)((Object)this$teamColorMode)).equals((Object)other$teamColorMode)) {
            return false;
        }
        String this$channel = this.getChannel();
        String other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !this$channel.equals(other$channel)) {
            return false;
        }
        Map<String, String> this$serverChannels = this.getServerChannels();
        Map<String, String> other$serverChannels = other.getServerChannels();
        return !(this$serverChannels == null ? other$serverChannels != null : !((Object)this$serverChannels).equals(other$serverChannels));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ClientConfig;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getPingVolume();
        result = result * 59 + this.getPingDuration();
        result = result * 59 + this.getPingDistance();
        result = result * 59 + Float.floatToIntBits(this.getCorrectionPeriod());
        result = result * 59 + (this.isItemIconVisible() ? 79 : 97);
        result = result * 59 + (this.isDirectionIndicatorVisible() ? 79 : 97);
        result = result * 59 + this.getPingSize();
        result = result * 59 + this.getRemoveRadius();
        result = result * 59 + this.getRaycastDistance();
        result = result * 59 + this.getSafeZoneLeft();
        result = result * 59 + this.getSafeZoneRight();
        result = result * 59 + this.getSafeZoneTop();
        result = result * 59 + this.getSafeZoneBottom();
        PlayerInfoMode $playerInfoMode = this.getPlayerInfoMode();
        result = result * 59 + ($playerInfoMode == null ? 43 : ((Object)((Object)$playerInfoMode)).hashCode());
        TeamColorMode $teamColorMode = this.getTeamColorMode();
        result = result * 59 + ($teamColorMode == null ? 43 : ((Object)((Object)$teamColorMode)).hashCode());
        String $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : $channel.hashCode());
        Map<String, String> $serverChannels = this.getServerChannels();
        result = result * 59 + ($serverChannels == null ? 43 : ((Object)$serverChannels).hashCode());
        return result;
    }
}

