/*
 * Decompiled with CFR 0.152.
 */
package io.github.foundationgames.automobility.automobile.attachment.rear;

import io.github.foundationgames.automobility.automobile.attachment.RearAttachmentType;
import io.github.foundationgames.automobility.automobile.attachment.rear.ExtendableRearAttachment;
import io.github.foundationgames.automobility.entity.AutomobileEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public abstract class BasePlowRearAttachment
extends ExtendableRearAttachment {
    private final BlockPos.MutableBlockPos blockIter = new BlockPos.MutableBlockPos();
    private Vec3 lastPos = null;

    public BasePlowRearAttachment(RearAttachmentType<?> type, AutomobileEntity entity) {
        super(type, entity);
        this.setExtended(true);
    }

    @Override
    public void tick() {
        Level level;
        super.tick();
        Vec3 pos = this.origin().m_82549_(this.yawVec().m_82490_(0.11 * (double)((RearAttachmentType)this.type).model().pivotDistPx()));
        if (this.extended() && this.canModifyBlocks() && this.lastPos != null && this.lastPos.m_82546_(pos).m_82553_() > 0.03 && (level = this.world()) instanceof ServerLevel) {
            ServerLevel world = (ServerLevel)level;
            this.plow(pos, world);
        }
        this.lastPos = pos;
    }

    public void plow(Vec3 pos, ServerLevel world) {
        int minX = (int)Math.floor(pos.f_82479_ - 0.5);
        int maxX = (int)Math.floor(pos.f_82479_ + 0.5);
        int minZ = (int)Math.floor(pos.f_82481_ - 0.5);
        int maxZ = (int)Math.floor(pos.f_82481_ + 0.5);
        int y = (int)Math.floor(pos.f_82480_ + this.searchHeight());
        boolean playSound = false;
        for (int x = minX; x <= maxX; ++x) {
            for (int z = minZ; z <= maxZ; ++z) {
                this.blockIter.m_122178_(x, y, z);
                BlockState state = world.m_8055_((BlockPos)this.blockIter);
                BlockState result = this.plowResult((BlockPos)this.blockIter, state);
                if (result == state) continue;
                world.m_46597_((BlockPos)this.blockIter, result);
                playSound = true;
            }
        }
        if (playSound) {
            world.m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, this.plowSound(), SoundSource.BLOCKS, 0.8f, 1.0f);
        }
    }

    @Override
    public void setExtended(boolean deployed) {
        if (!this.world().m_5776_() && deployed != this.extended()) {
            Vec3 pos = this.pos();
            this.world().m_6263_(null, pos.f_82479_, pos.f_82480_, pos.f_82481_, SoundEvents.f_12011_, SoundSource.PLAYERS, 0.6f, 1.4f);
        }
        super.setExtended(deployed);
    }

    public abstract SoundEvent plowSound();

    public abstract double searchHeight();

    public abstract BlockState plowResult(BlockPos var1, BlockState var2);

    @Override
    protected int extendAnimTime() {
        return 3;
    }
}

