/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.client.renderer;

import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.Drawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.BlockEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.config.ClientConfig;
import com.jaquadro.minecraft.storagedrawers.util.CountFormatter;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Matrix4f;

@OnlyIn(value=Dist.CLIENT)
public class BlockEntityDrawersRenderer
implements BlockEntityRenderer<BlockEntityDrawers> {
    private final ItemStack[] renderStacks = new ItemStack[4];
    private ItemRenderer itemRenderer;
    private final BlockEntityRendererProvider.Context context;
    private static final int TEXT_COLOR_TRANSPARENT = FastColor.ARGB32.m_13660_((int)0, (int)255, (int)255, (int)255);
    private static final Matrix3f ITEM_LIGHT_ROTATION_3D = new Matrix3f().rotationYXZ(0.261799f, -0.261799f, 0.0f);
    private static final Matrix3f ITEM_LIGHT_ROTATION_FLAT = new Matrix3f().rotationYXZ(0.0f, -0.785398f, 0.0f);
    private static final float[] sideRotationY2D = new float[]{0.0f, 0.0f, 2.0f, 0.0f, 3.0f, 1.0f};
    public static final ResourceLocation TEXTURE_IND_1 = StorageDrawers.rl("block/indicator/indicator_1_on");
    public static final ResourceLocation TEXTURE_IND_2 = StorageDrawers.rl("block/indicator/indicator_2_on");
    public static final ResourceLocation TEXTURE_IND_4 = StorageDrawers.rl("block/indicator/indicator_4_on");
    public static final ResourceLocation TEXTURE_IND_COMP_3 = StorageDrawers.rl("block/indicator/indicator_comp_on");
    public static final ResourceLocation TEXTURE_IND_COMP_2 = StorageDrawers.rl("block/indicator/indicator_comp2_on");

    public BlockEntityDrawersRenderer(BlockEntityRendererProvider.Context context) {
        this.context = context;
    }

    public void render(@NotNull BlockEntityDrawers blockEntityDrawers, float partialTickTime, @NotNull PoseStack matrix, @NotNull MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return;
        }
        Level level = blockEntityDrawers.m_58904_();
        if (level == null) {
            return;
        }
        BlockState state = blockEntityDrawers.m_58900_();
        if (!(state.m_60734_() instanceof BlockDrawers)) {
            return;
        }
        Direction side = (Direction)state.m_61143_((Property)BlockDrawers.f_54117_);
        if (this.playerBehindBlock(blockEntityDrawers.m_58899_(), side)) {
            return;
        }
        float distance = (float)Math.sqrt(blockEntityDrawers.m_58899_().m_203193_((Position)player.m_20182_()));
        double renderDistance = (Double)ClientConfig.RENDER.labelRenderDistance.get();
        if (renderDistance > 0.0 && (double)distance > renderDistance) {
            return;
        }
        this.itemRenderer = Minecraft.m_91087_().m_91291_();
        if (blockEntityDrawers.upgrades().hasIlluminationUpgrade()) {
            int blockLight = Math.max(combinedLight % 65536, 208);
            combinedLight = combinedLight & 0xFFFF0000 | blockLight;
        }
        if (!blockEntityDrawers.getDrawerAttributes().isConcealed()) {
            this.renderFastItemSet(blockEntityDrawers, state, matrix, buffer, combinedLight, combinedOverlay, side, partialTickTime, distance);
        }
        if (blockEntityDrawers.getDrawerAttributes().hasFillLevel()) {
            this.renderIndicator((BlockDrawers)state.m_60734_(), blockEntityDrawers, matrix, buffer, (Direction)state.m_61143_((Property)BlockDrawers.f_54117_), combinedLight, combinedOverlay);
        }
    }

    private boolean playerBehindBlock(BlockPos blockPos, Direction facing) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player == null) {
            return false;
        }
        BlockPos playerPos = player.m_20183_();
        return switch (facing) {
            case Direction.NORTH -> {
                if (playerPos.m_123343_() > blockPos.m_123343_()) {
                    yield true;
                }
                yield false;
            }
            case Direction.SOUTH -> {
                if (playerPos.m_123343_() < blockPos.m_123343_()) {
                    yield true;
                }
                yield false;
            }
            case Direction.WEST -> {
                if (playerPos.m_123341_() > blockPos.m_123341_()) {
                    yield true;
                }
                yield false;
            }
            case Direction.EAST -> {
                if (playerPos.m_123341_() < blockPos.m_123341_()) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    private void renderFastItemSet(BlockEntityDrawers blockEntityDrawers, BlockState state, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Direction side, float partialTickTime, float distance) {
        int i;
        int drawerCount = blockEntityDrawers.getGroup().getDrawerCount();
        for (i = 0; i < drawerCount; ++i) {
            ItemStack itemStack;
            this.renderStacks[i] = ItemStack.f_41583_;
            IDrawer drawer = blockEntityDrawers.getGroup().getDrawer(i);
            if (!drawer.isEnabled() || drawer.isEmpty()) continue;
            this.renderStacks[i] = itemStack = drawer.getStoredItemPrototype();
        }
        for (i = 0; i < drawerCount; ++i) {
            ItemStack itemStack = this.renderStacks[i];
            if (itemStack.m_41619_()) continue;
            this.renderFastItem(itemStack, state, i, matrix, buffer, combinedLight, combinedOverlay, side);
        }
        if (blockEntityDrawers.getDrawerAttributes().isShowingQuantity()) {
            double renderDistance;
            float alpha = 1.0f;
            double fadeDistance = (Double)ClientConfig.RENDER.quantityFadeDistance.get();
            if (fadeDistance == 0.0 || (double)distance > fadeDistance) {
                alpha = Math.max(1.0f - (distance - 4.0f) / 6.0f, 0.05f);
            }
            if ((renderDistance = ((Double)ClientConfig.RENDER.quantityRenderDistance.get()).doubleValue()) == 0.0 || (double)distance < renderDistance) {
                for (int i2 = 0; i2 < drawerCount; ++i2) {
                    String format = CountFormatter.format(this.context.m_173586_(), blockEntityDrawers.getGroup().getDrawer(i2));
                    this.renderText(format, state, i2, matrix, buffer, combinedLight, side, alpha);
                }
            }
        }
    }

    private void renderText(String text, BlockState state, int slot, PoseStack matrix, MultiBufferSource buffer, int combinedLight, Direction side, float alpha) {
        if (text == null || text.isEmpty()) {
            return;
        }
        Font fontRenderer = this.context.m_173586_();
        BlockDrawers block = (BlockDrawers)state.m_60734_();
        AABB labelGeometry = block.countGeometry[slot];
        int textWidth = fontRenderer.m_92895_(text);
        float x = (float)(labelGeometry.f_82288_ + labelGeometry.m_82362_() / 2.0);
        float y = 16.0f - (float)labelGeometry.f_82289_ - (float)labelGeometry.m_82376_();
        float z = (float)labelGeometry.f_82290_ * 0.0625f - 0.01f;
        matrix.m_85836_();
        this.alignRendering(matrix, side);
        matrix.m_252880_(x / 16.0f, 1.0f - y / 16.0f, 1.0f - z);
        matrix.m_85841_(0.0078125f, -0.0078125f, 1.0f);
        int color = (int)(255.0f * alpha) << 24 | TEXT_COLOR_TRANSPARENT;
        fontRenderer.m_271703_(text, (float)(-textWidth) / 2.0f, 0.0f, color, false, matrix.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, combinedLight);
        matrix.m_85849_();
    }

    private void renderFastItem(@NotNull ItemStack itemStack, BlockState state, int slot, PoseStack matrix, MultiBufferSource buffer, int combinedLight, int combinedOverlay, Direction side) {
        BlockDrawers block = (BlockDrawers)state.m_60734_();
        AABB labelGeometry = block.labelGeometry[slot];
        float scaleX = (float)labelGeometry.m_82362_() / 16.0f;
        float scaleY = (float)labelGeometry.m_82376_() / 16.0f;
        float moveX = (float)labelGeometry.f_82288_ + 8.0f * scaleX;
        float moveY = 16.0f - (float)labelGeometry.f_82292_ + 8.0f * scaleY;
        float moveZ = (float)labelGeometry.f_82290_ * 0.0625f - 0.0025f;
        matrix.m_85836_();
        this.alignRendering(matrix, side);
        matrix.m_252880_(moveX / 16.0f, 1.0f - moveY / 16.0f, 1.0f - moveZ);
        matrix.m_252931_(new Matrix4f().scale(scaleX, scaleY, 0.001f));
        try {
            BakedModel itemModel = this.itemRenderer.m_174264_(itemStack, null, null, 0);
            if (itemModel.m_7539_()) {
                matrix.m_85850_().m_252943_().mul((Matrix3fc)ITEM_LIGHT_ROTATION_3D);
            } else {
                matrix.m_85850_().m_252943_().mul((Matrix3fc)ITEM_LIGHT_ROTATION_FLAT);
            }
            ItemDisplayContext context = ItemDisplayContext.GUI;
            if (itemModel.m_7521_()) {
                context = ItemDisplayContext.FIXED;
            }
            this.itemRenderer.m_115143_(itemStack, context, false, matrix, buffer, combinedLight, combinedOverlay, itemModel);
        }
        catch (Exception exception) {
            // empty catch block
        }
        matrix.m_85849_();
    }

    private void alignRendering(PoseStack matrix, Direction side) {
        matrix.m_252880_(0.5f, 0.0f, 0.5f);
        matrix.m_252931_(new Matrix4f().rotateYXZ(this.getRotationYForSide2D(side), 0.0f, 0.0f));
        matrix.m_252880_(-0.5f, 0.0f, -0.5f);
    }

    private float getRotationYForSide2D(Direction side) {
        return sideRotationY2D[side.ordinal()] * 90.0f * (float)Math.PI / 180.0f;
    }

    private void renderIndicator(BlockDrawers block, BlockEntityDrawers blockEntityDrawers, PoseStack matrixStack, MultiBufferSource buffer, Direction side, int combinedLight, int combinedOverlay) {
        int count = blockEntityDrawers instanceof BlockEntityDrawersComp ? 1 : block.getDrawerCount();
        ResourceLocation resource = TEXTURE_IND_1;
        if (blockEntityDrawers instanceof BlockEntityDrawersComp) {
            resource = block.getDrawerCount() == 2 ? TEXTURE_IND_COMP_2 : TEXTURE_IND_COMP_3;
        } else if (count == 2) {
            resource = TEXTURE_IND_2;
        } else if (count == 4) {
            resource = TEXTURE_IND_4;
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(resource);
        SpriteContents contents = sprite.m_245424_();
        float u1 = sprite.m_118409_();
        float u2 = sprite.m_118410_();
        float v1 = sprite.m_118411_();
        float v2 = sprite.m_118412_();
        float pxW = contents.m_246492_();
        float pxH = contents.m_245330_();
        float unit = 0.0625f;
        float divU = unit * (u2 - u1);
        float divV = unit * (v2 - v1);
        matrixStack.m_85836_();
        this.alignRendering(matrixStack, side);
        for (int i = 0; i < count; ++i) {
            IDrawer drawer = blockEntityDrawers.getGroup().getDrawer(i);
            if (drawer == Drawers.DISABLED || blockEntityDrawers.getDrawerAttributes().isConcealed()) continue;
            AABB bb = block.indGeometry[i];
            AABB bbbase = block.indBaseGeometry[i];
            float x1 = unit * (float)bb.f_82288_;
            float x2 = unit * (float)bb.f_82291_;
            float xb2 = unit * (float)bbbase.f_82291_;
            float y1 = unit * (float)bb.f_82289_;
            float y2 = unit * (float)bb.f_82292_;
            float yb2 = unit * (float)bbbase.f_82292_;
            float z = 1.0f - unit * (float)bb.f_82290_;
            float su1 = u1 + (float)bb.f_82288_ * divU;
            float su2 = u1 + (float)bb.f_82291_ * divU;
            float sv1 = v2 - (float)bb.f_82289_ * divV;
            float sv2 = v2 - (float)bb.f_82292_ * divV;
            int stepX = (int)((x2 - xb2) * pxW);
            int stepY = (int)((y2 - yb2) * pxH);
            float xCur = stepX == 0 ? x2 : this.getIndEnd(blockEntityDrawers, i, x1, x2 - xb2, stepX);
            float xFrac = x2 == xb2 ? 1.0f : (xCur - x1) / (x2 - xb2);
            float uCur = su1 + xFrac * (su2 - su1);
            float yCur = stepY == 0 ? y2 : this.getIndEnd(blockEntityDrawers, i, y1, y2 - yb2, stepY);
            float yFrac = y2 == yb2 ? 1.0f : (yCur - y1) / (y2 - yb2);
            float vCur = sv1 + yFrac * (sv2 - sv1);
            if (!(xCur > x1) || !(yCur > y1)) continue;
            Matrix4f matrix = matrixStack.m_85850_().m_252922_();
            Matrix3f normal = matrixStack.m_85850_().m_252943_();
            VertexConsumer builder = buffer.m_6299_(RenderType.m_110463_());
            BlockEntityDrawersRenderer.addQuad(matrix, normal, builder, combinedLight, combinedOverlay, x1, xCur, y1, yCur, z, uCur, su1, sv1, vCur);
        }
        matrixStack.m_85849_();
    }

    public static void addQuad(Matrix4f matrix, Matrix3f normal, VertexConsumer buffer, int combinedLight, int combinedOverlay, float x1, float x2, float y1, float y2, float z, float u1, float u2, float v1, float v2) {
        BlockEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x2, y1, z, u1, v1);
        BlockEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x2, y2, z, u1, v2);
        BlockEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x1, y2, z, u2, v2);
        BlockEntityDrawersRenderer.addVertex(matrix, normal, buffer, combinedLight, combinedOverlay, x1, y1, z, u2, v1);
    }

    private static void addVertex(Matrix4f matrix, Matrix3f normal, VertexConsumer buffer, int combinedLight, int combinedOverlay, float x, float y, float z, float u, float v) {
        buffer.m_252986_(matrix, x, y, z).m_85950_(1.0f, 1.0f, 1.0f, 1.0f).m_7421_(u, v).m_86008_(combinedOverlay).m_85969_(combinedLight).m_252939_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    private float getIndEnd(BlockEntityDrawers blockEntityDrawers, int slot, float x, float w, int step) {
        IDrawer drawer = blockEntityDrawers.getGroup().getDrawer(slot);
        if (drawer == Drawers.DISABLED) {
            return x;
        }
        int cap = drawer.getMaxCapacity();
        int count = drawer.getStoredItemCount();
        if (cap == 0 || count == 0) {
            return x;
        }
        float fillAmt = (float)(step * count / cap) / (float)step;
        return x + w * fillAmt;
    }
}

