/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;

public class FloodFill {
    private List<Block> allowedBlocks;
    private List<Block> ignoredBlocks = Arrays.asList(Blocks.f_50493_, Blocks.f_50069_, Blocks.f_50652_, Blocks.f_50034_, Blocks.f_152481_, Blocks.f_49994_, Blocks.f_49992_, Blocks.f_50062_, Blocks.f_49990_, Blocks.f_50752_, Blocks.f_50259_);
    private int MAX_SEARCH_DEPTH = 2048;
    private int MAX_BLOCKS = 4196;
    private LevelReader world;
    private BlockPos startingPosition;
    private Map<BlockPos, BlockState> result;

    public FloodFill(LevelReader world, BlockPos startingPosition) {
        this.world = world;
        this.startingPosition = startingPosition;
    }

    public FloodFill(LevelReader world, BlockPos startingPos, Block ... allowedBlocks) {
        this(world, startingPos);
        this.allowedBlocks = List.of(allowedBlocks);
    }

    public FloodFill(LevelReader world, BlockPos startingPos, List allowedBlocks) {
        this(world, startingPos);
        this.allowedBlocks = allowedBlocks;
    }

    private static Map<BlockPos, BlockState> normalizeBlockPosMap(Map<BlockPos, BlockState> input) {
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int minX = Integer.MAX_VALUE;
        for (BlockPos pos : input.keySet()) {
            if (pos.m_123342_() < minY) {
                minY = pos.m_123342_();
            }
            if (pos.m_123343_() < minZ) {
                minZ = pos.m_123343_();
            }
            if (pos.m_123341_() >= minX) continue;
            minX = pos.m_123341_();
        }
        HashMap<BlockPos, BlockState> result = new HashMap<BlockPos, BlockState>();
        for (Map.Entry<BlockPos, BlockState> blockInfo : input.entrySet()) {
            result.put(blockInfo.getKey().m_7918_(-minX, -minY, -minZ), blockInfo.getValue());
        }
        return result;
    }

    public Map<BlockPos, BlockState> getConnectedBlocks(boolean normalize) {
        this.result = new HashMap<BlockPos, BlockState>();
        this.floodFill(this.world, this.startingPosition, 0);
        if (normalize) {
            return FloodFill.normalizeBlockPosMap(this.result);
        }
        return this.result;
    }

    public Map<BlockPos, BlockState> getConnectedBlocks() {
        return this.getConnectedBlocks(true);
    }

    private void floodFill(LevelReader world, BlockPos pos, int depth) {
        if (depth > this.MAX_SEARCH_DEPTH) {
            return;
        }
        if (this.result.size() > this.MAX_BLOCKS) {
            return;
        }
        if (this.result.containsKey(pos)) {
            return;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60795_()) {
            return;
        }
        if (this.ignoredBlocks.contains(state.m_60734_())) {
            return;
        }
        if (this.allowedBlocks != null && !this.allowedBlocks.contains(state.m_60734_())) {
            return;
        }
        this.result.put(pos, state);
        for (int x = -1; x < 2; ++x) {
            for (int y = -1; y < 2; ++y) {
                for (int z = -1; z < 2; ++z) {
                    if (x == 0 && y == 0 && z == 0) continue;
                    this.floodFill(world, pos.m_7918_(x, y, z), depth + 1);
                }
            }
        }
    }
}

