/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.function.Consumer;
import net.minecraft.world.item.crafting.Ingredient;

public class JsonHelpers {
    public static JsonObject insertAsArray(JsonObject parent, String key, JsonElement toInsert) {
        if (parent.has(key)) {
            parent.getAsJsonArray(key).add(toInsert);
        } else {
            JsonArray newArray = new JsonArray();
            newArray.add(toInsert);
            parent.add(key, (JsonElement)newArray);
        }
        return parent;
    }

    public static JsonObject insertAsArrayOrSingle(JsonObject parent, String key, JsonObject toInsert) {
        if (parent.has(key)) {
            JsonElement originalElement = parent.get(key);
            if (originalElement.isJsonArray()) {
                originalElement.getAsJsonArray().add((JsonElement)toInsert);
            } else {
                parent.remove(key);
                JsonArray arrayReplacement = new JsonArray(2);
                arrayReplacement.add(originalElement);
                arrayReplacement.add((JsonElement)toInsert);
                parent.add(key, (JsonElement)arrayReplacement);
            }
        } else {
            parent.add(key, (JsonElement)toInsert);
        }
        return parent;
    }

    public static Ingredient getIngredientFromArrayOrSingle(JsonElement json) {
        return Ingredient.m_43917_((JsonElement)json);
    }

    public static int processArrayOrSingle(JsonElement json, Consumer<JsonElement> c) {
        if (json == null) {
            return 0;
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            int count = array.size();
            array.forEach(c);
            return count;
        }
        c.accept(json);
        return 1;
    }
}

