/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework;

import com.davenonymous.libnonymous.gui.framework.GUI;
import com.davenonymous.libnonymous.gui.framework.event.CharTypedEvent;
import com.davenonymous.libnonymous.gui.framework.event.KeyPressedEvent;
import com.davenonymous.libnonymous.gui.framework.event.KeyReleasedEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseClickEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseMoveEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseReleasedEvent;
import com.davenonymous.libnonymous.gui.framework.event.MouseScrollEvent;
import com.davenonymous.libnonymous.gui.framework.event.UpdateScreenEvent;
import com.davenonymous.libnonymous.gui.framework.event.WidgetEventResult;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class WidgetScreen
extends Screen {
    protected GUI gui;
    private int previousMouseX = Integer.MAX_VALUE;
    private int previousMouseY = Integer.MAX_VALUE;
    protected ResourceLocation id;

    protected WidgetScreen(Component title) {
        super(title);
    }

    protected abstract GUI createGUI();

    public GUI getOrCreateGui() {
        if (this.gui == null) {
            this.gui = this.createGUI();
            this.gui.setVisible(true);
        }
        return this.gui;
    }

    public void m_86600_() {
        super.m_86600_();
        this.getOrCreateGui().fireEvent(new UpdateScreenEvent());
        this.resetMousePositions();
    }

    public boolean m_6375_(double mouseX, double mouseY, int mouseButton) {
        if (this.getOrCreateGui().fireEvent(new MouseClickEvent(mouseX, mouseY, mouseButton)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.m_6375_(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean m_6348_(double mouseX, double mouseY, int mouseButton) {
        if (this.getOrCreateGui().fireEvent(new MouseReleasedEvent(mouseX, mouseY, mouseButton)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.m_6348_(mouseX, mouseY, mouseButton);
        }
        return false;
    }

    public boolean m_7920_(int keyCode, int scanCode, int modifiers) {
        if (this.getOrCreateGui().fireEvent(new KeyReleasedEvent(keyCode, scanCode, modifiers)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.m_7920_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean m_5534_(char chr, int code) {
        if (this.getOrCreateGui().fireEvent(new CharTypedEvent(chr, code)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.m_5534_(chr, code);
        }
        return false;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        if (this.getOrCreateGui().fireEvent(new KeyPressedEvent(keyCode, scanCode, modifiers)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.m_7933_(keyCode, scanCode, modifiers);
        }
        return false;
    }

    public boolean m_6050_(double mouseX, double mouseY, double scrollAmount) {
        if (this.getOrCreateGui().fireEvent(new MouseScrollEvent(mouseX, mouseY, scrollAmount)) == WidgetEventResult.CONTINUE_PROCESSING) {
            return super.m_6050_(mouseX, mouseY, scrollAmount);
        }
        return false;
    }

    public void m_88315_(GuiGraphics pGuiGraphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(pGuiGraphics, mouseX, mouseY, partialTicks);
        if (mouseX != this.previousMouseX || mouseY != this.previousMouseY) {
            this.getOrCreateGui().fireEvent(new MouseMoveEvent(mouseX, mouseY));
            this.previousMouseX = mouseX;
            this.previousMouseY = mouseY;
        }
        this.getOrCreateGui().drawGUI(pGuiGraphics, this);
        this.getOrCreateGui().drawTooltips(pGuiGraphics, this, mouseX, mouseY);
    }

    public void m_280273_(GuiGraphics pGuiGraphics) {
        super.m_280273_(pGuiGraphics);
    }

    protected void resetMousePositions() {
        this.previousMouseX = Integer.MIN_VALUE;
        this.previousMouseY = Integer.MIN_VALUE;
    }

    public boolean m_7043_() {
        return false;
    }
}

