/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.gui.framework;

import com.davenonymous.libnonymous.gui.framework.GUIHelper;
import com.davenonymous.libnonymous.gui.framework.WidgetContainer;
import com.davenonymous.libnonymous.gui.framework.WidgetSlot;
import com.davenonymous.libnonymous.gui.framework.widgets.IValueProvider;
import com.davenonymous.libnonymous.gui.framework.widgets.Widget;
import com.davenonymous.libnonymous.gui.framework.widgets.WidgetPanel;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.Slot;

public class GUI
extends WidgetPanel {
    public static ResourceLocation tabIcons = new ResourceLocation("libnonymous", "textures/gui/tabicons.png");
    public static ResourceLocation defaultButtonTexture = new ResourceLocation("libnonymous", "textures/gui/button_background.png");
    public boolean hasTabs = false;
    private Map<ResourceLocation, IValueProvider> valueMap = new HashMap<ResourceLocation, IValueProvider>();
    private WidgetContainer container;

    public GUI(int x, int y, int width, int height) {
        this.setX(x);
        this.setY(y);
        this.setWidth(width);
        this.setHeight(height);
    }

    public void findValueWidgets() {
        this.findValueWidgets(this);
    }

    public void registerValueWidget(ResourceLocation id, IValueProvider widget) {
        this.valueMap.put(id, widget);
    }

    public Object getValue(ResourceLocation id) {
        if (id == null || !this.valueMap.containsKey(id)) {
            return null;
        }
        return this.valueMap.get(id).getValue();
    }

    public void drawGUI(GuiGraphics pGuiGraphics, Screen screen) {
        this.setX((screen.f_96543_ - this.width) / 2);
        this.setY((screen.f_96544_ - this.height) / 2);
        this.shiftAndDraw(pGuiGraphics, screen);
    }

    @Override
    public void drawBeforeShift(GuiGraphics pGuiGraphics, Screen screen) {
        super.drawBeforeShift(pGuiGraphics, screen);
    }

    @Override
    public void draw(GuiGraphics pGuiGraphics, Screen screen) {
        this.drawWindow(pGuiGraphics, screen);
        super.draw(pGuiGraphics, screen);
    }

    protected void drawWindow(GuiGraphics pGuiGraphics, Screen screen) {
        int texOffsetY = 11;
        int texOffsetX = 64;
        int width = this.width;
        int xOffset = 0;
        if (this.hasTabs) {
            width -= 32;
            xOffset += 32;
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tabIcons);
        pGuiGraphics.m_280218_(tabIcons, xOffset, 0, texOffsetX, texOffsetY, 4, 4);
        pGuiGraphics.m_280218_(tabIcons, xOffset + width - 4, 0, texOffsetX + 4 + 64, texOffsetY, 4, 4);
        pGuiGraphics.m_280218_(tabIcons, xOffset, this.height - 4, texOffsetX, texOffsetY + 4 + 64, 4, 4);
        pGuiGraphics.m_280218_(tabIcons, xOffset + width - 4, this.height - 4, texOffsetX + 4 + 64, texOffsetY + 4 + 64, 4, 4);
        GUIHelper.drawStretchedTexture(pGuiGraphics, xOffset + 4, 0, width - 8, 4, texOffsetX + 4, texOffsetY, 64, 4);
        GUIHelper.drawStretchedTexture(pGuiGraphics, xOffset + 4, this.height - 4, width - 8, 4, texOffsetX + 4, texOffsetY + 4 + 64, 64, 4);
        GUIHelper.drawStretchedTexture(pGuiGraphics, xOffset, 4, 4, this.height - 8, texOffsetX, texOffsetY + 4, 4, 64);
        GUIHelper.drawStretchedTexture(pGuiGraphics, xOffset + width - 4, 4, 4, this.height - 8, texOffsetX + 64 + 4, texOffsetY + 3, 4, 64);
        GUIHelper.drawStretchedTexture(pGuiGraphics, xOffset + 4, 4, width - 8, this.height - 8, texOffsetX + 4, texOffsetY + 4, 64, 64);
    }

    public void drawTooltips(GuiGraphics pGuiGraphics, Screen screen, int mouseX, int mouseY) {
        Widget hoveredWidget = this.getHoveredWidget(mouseX, mouseY);
        Font font = screen.getMinecraft().f_91062_;
        if (hoveredWidget != null && hoveredWidget.getTooltip() != null && hoveredWidget.getTooltip().size() > 0) {
            pGuiGraphics.m_280245_(font, hoveredWidget.getTooltipAsFormattedCharSequence(), mouseX, mouseY);
        }
    }

    public void drawSlot(GuiGraphics pGuiGraphics, Screen screen, Slot slot, int guiLeft, int guiTop) {
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        if (slot instanceof WidgetSlot && !slot.m_150651_((Player)screen.getMinecraft().f_91074_)) {
            RenderSystem.setShaderColor((float)1.0f, (float)0.3f, (float)0.3f, (float)1.0f);
        }
        float offsetX = guiLeft - 1;
        float offsetY = guiTop - 1;
        pGuiGraphics.m_280168_().m_85836_();
        pGuiGraphics.m_280168_().m_252880_(offsetX, offsetY, 0.0f);
        int texOffsetY = 84;
        int texOffsetX = 84;
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)tabIcons);
        pGuiGraphics.m_280218_(tabIcons, slot.f_40220_, slot.f_40221_, texOffsetX, texOffsetY, 18, 18);
        pGuiGraphics.m_280168_().m_85849_();
    }

    public void setContainer(WidgetContainer container) {
        this.container = container;
    }

    public WidgetContainer getContainer() {
        return this.container;
    }
}

