/*
 * Decompiled with CFR 0.152.
 */
package com.davenonymous.libnonymous.datagen;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BaseDataProvider
implements DataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private final DataGenerator generator;
    private final Type type;
    private Map<String, JsonObject> values = new HashMap<String, JsonObject>();

    public abstract void addValues();

    public abstract String getModId();

    public void add(String path, JsonObject value) {
        this.values.put(path, value);
    }

    public static float getRounded(double d) {
        DecimalFormat df = new DecimalFormat("#.##");
        DecimalFormatSymbols symbols = df.getDecimalFormatSymbols();
        symbols.setDecimalSeparator('.');
        df.setDecimalFormatSymbols(symbols);
        return Float.parseFloat(df.format(d));
    }

    public BaseDataProvider(DataGenerator generator, Type type) {
        this.type = type;
        this.generator = generator;
    }

    public CompletableFuture<?> m_213708_(CachedOutput cache) {
        this.addValues();
        return CompletableFuture.allOf((CompletableFuture[])this.values.entrySet().stream().map(table -> {
            String s = (String)table.getKey();
            JsonObject jsonObject = (JsonObject)table.getValue();
            return this.saveValue(cache, s, jsonObject);
        }).toArray(CompletableFuture[]::new));
    }

    private CompletableFuture<?> saveValue(CachedOutput cache, String key, JsonObject jsonObject) {
        Path mainOutput = this.generator.getPackOutput().m_245114_();
        String pathSuffix = (this.type == Type.ASSETS ? "assets" : "data") + "/" + this.getModId() + "/" + key + ".json";
        Path outputPath = mainOutput.resolve(pathSuffix);
        return DataProvider.m_253162_((CachedOutput)cache, (JsonElement)jsonObject, (Path)outputPath);
    }

    public static enum Type {
        ASSETS,
        DATA;

    }
}

