/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.lightoverlay.common.forge;

import net.minecraft.core.BlockPos;

public class CubicChunkPos {
    public final int x;
    public final int y;
    public final int z;

    public CubicChunkPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public CubicChunkPos(long l) {
        this.x = CubicChunkPos.getX(l);
        this.y = CubicChunkPos.getY(l);
        this.z = CubicChunkPos.getZ(l);
    }

    public CubicChunkPos(BlockPos blockPos) {
        this.x = blockPos.m_123341_() >> 4;
        this.y = blockPos.m_123342_() >> 5;
        this.z = blockPos.m_123343_() >> 4;
    }

    public long toLong() {
        return CubicChunkPos.asLong(this.x, this.y, this.z);
    }

    public static long asLong(int x, int y, int z) {
        return ((long)x & 0xFFFFFFL) << 36 | ((long)y & 0xFFFL) << 24 | (long)z & 0xFFFFFFL;
    }

    public static int getX(long l) {
        return (int)(l >> 36 & 0xFFFFFFL);
    }

    public static int getY(long l) {
        return (int)(l >> 24 & 0xFFFL);
    }

    public static int getZ(long l) {
        return (int)(l & 0xFFFFFFL);
    }

    public int getMinBlockX() {
        return this.x << 4;
    }

    public int getMinBlockY() {
        return this.y << 5;
    }

    public int getMinBlockZ() {
        return this.z << 4;
    }

    public int getMaxBlockX() {
        return (this.x << 4) + 15;
    }

    public int getMaxBlockY() {
        return (this.y << 5) + 31;
    }

    public int getMaxBlockZ() {
        return (this.z << 4) + 15;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CubicChunkPos that = (CubicChunkPos)o;
        return this.x == that.x && this.y == that.y && this.z == that.z;
    }

    public String toString() {
        return "CubicChunkPos{x=" + this.x + ", y=" + this.y + ", z=" + this.z + "}";
    }

    public int hashCode() {
        return Long.hashCode(this.toLong());
    }
}

