/*
 * Decompiled with CFR 0.152.
 */
package com.tom.createores.util;

import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;

public class BiomeTooltip {
    private static long lastBiomeChangeTime;
    private static int biomePage;

    public static void listBiomes(TagKey<Biome> tag, List<Component> tooltip) {
        boolean isShift = Screen.m_96638_();
        Registry biomeReg = Minecraft.m_91087_().m_91403_().m_105152_().m_175515_(Registries.f_256952_);
        biomeReg.m_203431_(tag).map(t -> {
            Stream<Holder> s = t.m_203614_();
            int size = t.m_203632_();
            MutableComponent pg = null;
            if (size > 16) {
                if (!isShift && System.currentTimeMillis() - lastBiomeChangeTime > 2000L) {
                    if (++biomePage * 16 >= size) {
                        biomePage = 0;
                    }
                    lastBiomeChangeTime = System.currentTimeMillis();
                }
                pg = Component.m_237110_((String)"tooltip.coe.page", (Object[])new Object[]{biomePage + 1, size / 16 + 1});
                s = s.skip(biomePage * 16).limit(16L);
            }
            List comps = s.map(b -> BiomeTooltip.getBiomeId((Registry<Biome>)biomeReg, (Holder<Biome>)b)).map(b -> Component.m_237115_((String)("biome." + b.m_135827_() + "." + b.m_135815_()))).collect(Collectors.toList());
            if (pg != null) {
                comps.add(pg);
            }
            return comps;
        }).ifPresent(tooltip::addAll);
    }

    private static ResourceLocation getBiomeId(Registry<Biome> biomeReg, Holder<Biome> h) {
        try {
            if (h.m_203376_() == Holder.Kind.DIRECT) {
                return biomeReg.m_7981_((Object)((Biome)h.m_203334_()));
            }
            return ((Holder.Reference)h).m_205785_().m_135782_();
        }
        catch (Exception e) {
            return new ResourceLocation("null");
        }
    }

    public static void resetPage() {
        biomePage = 0;
        lastBiomeChangeTime = 0L;
    }
}

