/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.particle.impl;

import cofh.core.client.particle.impl.GasParticle;
import cofh.core.client.particle.options.ColorParticleOptions;
import cofh.core.common.TransientLightManager;
import cofh.core.common.config.CoreClientConfig;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import javax.annotation.Nonnull;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.core.BlockPos;

public class FireParticle
extends GasParticle {
    private FireParticle(ColorParticleOptions data, ClientLevel level, SpriteSet sprites, double x, double y, double z, double dx, double dy, double dz) {
        super(data, level, sprites, x, y, z, dx, dy, dz);
        this.f_107226_ = -0.3f;
        this.f_172258_ = 0.9f;
        this.groundFriction = 0.2f;
    }

    @Override
    public void m_5989_() {
        super.m_5989_();
        if (CoreClientConfig.particleDynamicLighting.get().booleanValue() && (float)this.f_107224_ >= this.delay) {
            int x = MathHelper.floor(this.f_107212_);
            int y = MathHelper.floor(this.f_107213_);
            int z = MathHelper.floor(this.f_107214_);
            TransientLightManager.addLight(BlockPos.m_121882_((int)x, (int)y, (int)z), this.getDynamicLightLevel());
        }
    }

    protected int getDynamicLightLevel() {
        return Math.max(0, MathHelper.floor(10.0f - 10.0f * ((float)this.f_107224_ - this.delay) / this.duration)) + 1;
    }

    @Override
    public void render(PoseStack stack, MultiBufferSource buffer, VertexConsumer consumer, int packedLight, float time, float pTicks) {
        float progress = time / this.duration;
        float easeCub = 1.0f - MathHelper.easeInCubic(progress);
        this.setColor0(this.baseColor.scaleAlpha(easeCub));
        this.size = this.f_107221_ * MathHelper.sin(0.7853982f * (progress + 1.0f));
        super.render(stack, buffer, consumer, packedLight, time, pTicks);
    }

    @Override
    public ParticleRenderType m_7556_() {
        return RenderTypes.PARTICLE_SHEET_ADDITIVE_MULTIPLY;
    }

    @Override
    public int m_6355_(float partialTicks) {
        return 0xF000F0;
    }

    @Nonnull
    public static ParticleProvider<ColorParticleOptions> factory(SpriteSet spriteSet) {
        return (data, level, x, y, z, dx, dy, dz) -> new FireParticle((ColorParticleOptions)data, level, spriteSet, x, y, z, dx, dy, dz);
    }
}

