/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.util;

import com.mojang.blaze3d.vertex.PoseStack;
import dan200.computercraft.api.turtle.ITurtleAccess;
import dan200.computercraft.api.turtle.ITurtleUpgrade;
import dan200.computercraft.api.turtle.TurtleSide;
import dan200.computercraft.api.upgrades.UpgradeData;
import dan200.computercraft.shared.turtle.blocks.TurtleBlockEntity;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.world.item.Item;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import site.siredvin.turtlematic.api.AutomataCoreTraits;
import site.siredvin.turtlematic.client.RenderTrickOpcode;
import site.siredvin.turtlematic.client.TurtleRenderTrick;
import site.siredvin.turtlematic.client.TurtleRenderTrickRegistry;
import site.siredvin.turtlematic.common.items.base.BaseAutomataCore;
import site.siredvin.turtlematic.util.PairMonad;
import site.siredvin.tweakium.modules.peripheral.api.IDataStorage;
import site.siredvin.tweakium.modules.peripheral.util.CompoundTagDataStorage;
import site.siredvin.tweakium.modules.turtle.api.TurtleUpgradeHolder;

public class MixinToolkit {
    @Nullable
    public static PairMonad<TurtleRenderTrick, IDataStorage> searchRenderTrickWithData(@Nonnull ITurtleUpgrade upgrade, @Nonnull ITurtleAccess access, @Nonnull TurtleSide side) {
        TurtleRenderTrick coreTrick = TurtleRenderTrickRegistry.INSTANCE.getTrick(upgrade);
        if (coreTrick != null) {
            return new PairMonad<TurtleRenderTrick, CompoundTagDataStorage>(coreTrick, new CompoundTagDataStorage(access.getUpgradeNBTData(side), () -> null));
        }
        if (upgrade instanceof TurtleUpgradeHolder) {
            TurtleUpgradeHolder upgradeHolder = (TurtleUpgradeHolder)upgrade;
            for (UpgradeData internalUpgrade : upgradeHolder.getInternalUpgrades(access, side)) {
                TurtleRenderTrick internalTrick = TurtleRenderTrickRegistry.INSTANCE.getTrick((ITurtleUpgrade)internalUpgrade.upgrade());
                if (internalTrick == null) continue;
                return new PairMonad<TurtleRenderTrick, CompoundTagDataStorage>(internalTrick, new CompoundTagDataStorage(internalUpgrade.data(), () -> null));
            }
        }
        return null;
    }

    public static void render(@Nonnull TurtleBlockEntity turtle, float partialTicks, @Nonnull PoseStack transform, @Nonnull MultiBufferSource buffers, int lightmapCoord, int overlayLight, CallbackInfo info) {
        PairMonad<TurtleRenderTrick, IDataStorage> rightRenderTrick;
        RenderTrickOpcode opcode;
        PairMonad<TurtleRenderTrick, IDataStorage> leftRenderTrick;
        ITurtleUpgrade leftUpgrade = turtle.getUpgrade(TurtleSide.LEFT);
        ITurtleUpgrade rightUpgrade = turtle.getUpgrade(TurtleSide.RIGHT);
        ITurtleAccess access = turtle.getAccess();
        boolean cancelTurtleRender = false;
        if (leftUpgrade != null && (leftRenderTrick = MixinToolkit.searchRenderTrickWithData(leftUpgrade, access, TurtleSide.LEFT)) != null && (opcode = leftRenderTrick.first().render(turtle, access, TurtleSide.LEFT, leftRenderTrick.second(), partialTicks, transform, buffers, lightmapCoord, overlayLight)) == RenderTrickOpcode.CANCEL_RENDER) {
            cancelTurtleRender = true;
        }
        if (rightUpgrade != null && (rightRenderTrick = MixinToolkit.searchRenderTrickWithData(rightUpgrade, access, TurtleSide.RIGHT)) != null && (opcode = rightRenderTrick.first().render(turtle, access, TurtleSide.RIGHT, rightRenderTrick.second(), partialTicks, transform, buffers, lightmapCoord, overlayLight)) == RenderTrickOpcode.CANCEL_RENDER) {
            cancelTurtleRender = true;
        }
        if (cancelTurtleRender) {
            info.cancel();
        }
    }

    public static void isFuelNeeded(Map<TurtleSide, ITurtleUpgrade> upgrades, CallbackInfoReturnable<Boolean> cir) {
        boolean isFuelConsumptionDisabled;
        if (((Boolean)cir.getReturnValue()).booleanValue() && (isFuelConsumptionDisabled = upgrades.values().stream().anyMatch(it -> {
            Item item = it.getCraftingItem().m_41720_();
            if (item instanceof BaseAutomataCore) {
                BaseAutomataCore core = (BaseAutomataCore)item;
                return core.getCoreTier().getTraits().contains(AutomataCoreTraits.INSTANCE.getFUEL_CONSUMPTION_DISABLED());
            }
            return false;
        }))) {
            cir.setReturnValue((Object)false);
        }
    }
}

