/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.common.recipe;

import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import site.siredvin.turtlematic.common.recipe.SoulHarvestIngredient;
import site.siredvin.turtlematic.common.recipe.SoulHarvestRecipeRegistry;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u001d\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u0014J\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0016\u001a\u00020\u000e2\u0006\u0010\u0013\u001a\u00020\u0014J&\u0010\u0017\u001a\u0012\u0012\u0006\u0012\u0004\u0018\u00010\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u00182\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u0010J\u000f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0006H\u00c6\u0003J#\u0010\u001d\u001a\u00020\u00002\u000e\b\u0002\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u0006H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u000e2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020\u0012H\u00d6\u0001R\u0017\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006#"}, d2={"Lsite/siredvin/turtlematic/common/recipe/SoulHarvestRecipe;", "", "ingredients", "", "Lsite/siredvin/turtlematic/common/recipe/SoulHarvestIngredient;", "resultSoul", "Lnet/minecraft/world/item/Item;", "<init>", "(Ljava/util/List;Lnet/minecraft/world/item/Item;)V", "getIngredients", "()Ljava/util/List;", "getResultSoul", "()Lnet/minecraft/world/item/Item;", "isSuitable", "", "entity", "Lnet/minecraft/world/entity/Entity;", "name", "", "consumedData", "Lnet/minecraft/nbt/CompoundTag;", "targetIngredient", "isFinished", "consumeEntity", "Lkotlin/Pair;", "Lnet/minecraft/world/item/ItemStack;", "stack", "component1", "component2", "copy", "equals", "other", "hashCode", "", "toString", "turtlematic-forge-1.20.1"})
public final class SoulHarvestRecipe {
    @NotNull
    private final List<SoulHarvestIngredient> ingredients;
    @NotNull
    private final Item resultSoul;

    public SoulHarvestRecipe(@NotNull List<? extends SoulHarvestIngredient> ingredients, @NotNull Item resultSoul) {
        Intrinsics.checkNotNullParameter(ingredients, (String)"ingredients");
        Intrinsics.checkNotNullParameter((Object)resultSoul, (String)"resultSoul");
        this.ingredients = ingredients;
        this.resultSoul = resultSoul;
    }

    @NotNull
    public final List<SoulHarvestIngredient> getIngredients() {
        return this.ingredients;
    }

    @NotNull
    public final Item getResultSoul() {
        return this.resultSoul;
    }

    public final boolean isSuitable(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        for (SoulHarvestIngredient ingredient : this.ingredients) {
            if (!ingredient.match(entity)) continue;
            return true;
        }
        return false;
    }

    public final boolean isSuitable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        for (SoulHarvestIngredient ingredient : this.ingredients) {
            if (!Intrinsics.areEqual((Object)ingredient.getName(), (Object)name)) continue;
            return true;
        }
        return false;
    }

    public final boolean isSuitable(@NotNull Entity entity, @NotNull CompoundTag consumedData) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        Intrinsics.checkNotNullParameter((Object)consumedData, (String)"consumedData");
        for (SoulHarvestIngredient ingredient : this.ingredients) {
            if (!ingredient.match(entity)) continue;
            int currentCount = consumedData.m_128469_(ingredient.getName()).m_128451_(SoulHarvestRecipeRegistry.INSTANCE.getCONSUMED_ENTITY_COUNT());
            return currentCount < ingredient.getRequiredCount();
        }
        return false;
    }

    @Nullable
    public final SoulHarvestIngredient targetIngredient(@NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        for (SoulHarvestIngredient ingredient : this.ingredients) {
            if (!ingredient.match(entity)) continue;
            return ingredient;
        }
        return null;
    }

    public final boolean isFinished(@NotNull CompoundTag consumedData) {
        Intrinsics.checkNotNullParameter((Object)consumedData, (String)"consumedData");
        return this.ingredients.stream().filter(arg_0 -> SoulHarvestRecipe.isFinished$lambda$1(arg_0 -> SoulHarvestRecipe.isFinished$lambda$0(consumedData, arg_0), arg_0)).findAny().isEmpty();
    }

    @NotNull
    public final Pair<ItemStack, String> consumeEntity(@NotNull ItemStack stack, @NotNull Entity entity) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        Intrinsics.checkNotNullParameter((Object)entity, (String)"entity");
        SoulHarvestIngredient soulHarvestIngredient = this.targetIngredient(entity);
        if (soulHarvestIngredient == null) {
            return new Pair(null, (Object)"Cannot find ingredient that match this entity");
        }
        SoulHarvestIngredient targetIngredient = soulHarvestIngredient;
        entity.m_142687_(Entity.RemovalReason.KILLED);
        CompoundTag tag = stack.m_41784_();
        CompoundTag consumedData = tag.m_128469_(SoulHarvestRecipeRegistry.INSTANCE.getCONSUMER_ENTITY_COMPOUND());
        CompoundTag entityCompound = consumedData.m_128469_(targetIngredient.getName());
        entityCompound.m_128405_(SoulHarvestRecipeRegistry.INSTANCE.getCONSUMED_ENTITY_COUNT(), entityCompound.m_128451_(SoulHarvestRecipeRegistry.INSTANCE.getCONSUMED_ENTITY_COUNT()) + 1);
        entityCompound.m_128359_(SoulHarvestRecipeRegistry.INSTANCE.getCONSUMED_ENTITY_NAME(), entity.m_7755_().getString());
        consumedData.m_128365_(targetIngredient.getName(), (Tag)entityCompound);
        tag.m_128365_(SoulHarvestRecipeRegistry.INSTANCE.getCONSUMER_ENTITY_COMPOUND(), (Tag)consumedData);
        Intrinsics.checkNotNull((Object)consumedData);
        if (this.isFinished(consumedData)) {
            return new Pair((Object)this.resultSoul.m_7968_(), null);
        }
        return new Pair((Object)stack, null);
    }

    @NotNull
    public final List<SoulHarvestIngredient> component1() {
        return this.ingredients;
    }

    @NotNull
    public final Item component2() {
        return this.resultSoul;
    }

    @NotNull
    public final SoulHarvestRecipe copy(@NotNull List<? extends SoulHarvestIngredient> ingredients, @NotNull Item resultSoul) {
        Intrinsics.checkNotNullParameter(ingredients, (String)"ingredients");
        Intrinsics.checkNotNullParameter((Object)resultSoul, (String)"resultSoul");
        return new SoulHarvestRecipe(ingredients, resultSoul);
    }

    public static /* synthetic */ SoulHarvestRecipe copy$default(SoulHarvestRecipe soulHarvestRecipe, List list, Item item, int n, Object object) {
        if ((n & 1) != 0) {
            list = soulHarvestRecipe.ingredients;
        }
        if ((n & 2) != 0) {
            item = soulHarvestRecipe.resultSoul;
        }
        return soulHarvestRecipe.copy(list, item);
    }

    @NotNull
    public String toString() {
        return "SoulHarvestRecipe(ingredients=" + this.ingredients + ", resultSoul=" + this.resultSoul + ")";
    }

    public int hashCode() {
        int result = ((Object)this.ingredients).hashCode();
        result = result * 31 + this.resultSoul.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SoulHarvestRecipe)) {
            return false;
        }
        SoulHarvestRecipe soulHarvestRecipe = (SoulHarvestRecipe)other;
        if (!Intrinsics.areEqual(this.ingredients, soulHarvestRecipe.ingredients)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.resultSoul, (Object)soulHarvestRecipe.resultSoul);
    }

    private static final boolean isFinished$lambda$0(CompoundTag $consumedData, SoulHarvestIngredient it) {
        Intrinsics.checkNotNullParameter((Object)$consumedData, (String)"$consumedData");
        return it.getRequiredCount() != $consumedData.m_128469_(it.getName()).m_128451_(SoulHarvestRecipeRegistry.INSTANCE.getCONSUMED_ENTITY_COUNT());
    }

    private static final boolean isFinished$lambda$1(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }
}

