/*
 * Decompiled with CFR 0.152.
 */
package site.siredvin.turtlematic.client;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.List;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import site.siredvin.tweakium.modules.rml1.RMLParser;
import site.siredvin.tweakium.modules.rml1.RMLParsingException;
import site.siredvin.tweakium.modules.rml1.RenderInstruction;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0006\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\bJ\u0016\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\bH\u0002J\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u000b0\n2\u0006\u0010\u000e\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000Rh\u0010\u0006\u001aZ\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000b \t*\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\n \t*,\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u000b \t*\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n0\n\u0018\u00010\u00070\u0007X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\f\u00a8\u0006\u0011"}, d2={"Lsite/siredvin/turtlematic/client/RenderUtil;", "", "<init>", "()V", "parser", "Lsite/siredvin/tweakium/modules/rml1/RMLParser;", "cache", "Lcom/google/common/cache/LoadingCache;", "", "kotlin.jvm.PlatformType", "", "Lsite/siredvin/tweakium/modules/rml1/RenderInstruction;", "Lcom/google/common/cache/LoadingCache;", "parseRMLRaw", "string", "parseRMLRawProtected", "parseRML", "turtlematic-forge-1.20.1"})
public final class RenderUtil {
    @NotNull
    public static final RenderUtil INSTANCE = new RenderUtil();
    @NotNull
    private static final RMLParser parser = new RMLParser();
    private static final LoadingCache<String, List<RenderInstruction>> cache = CacheBuilder.newBuilder().expireAfterAccess(30L, TimeUnit.SECONDS).maximumSize(3000L).build(CacheLoader.from(INSTANCE::parseRMLRawProtected));

    private RenderUtil() {
    }

    @NotNull
    public final List<RenderInstruction> parseRMLRaw(@NotNull String string) throws RMLParsingException {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        return parser.parse(string);
    }

    private final List<RenderInstruction> parseRMLRawProtected(String string) {
        List<RenderInstruction> list;
        try {
            list = this.parseRMLRaw(string);
        }
        catch (RMLParsingException ignored) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final List<RenderInstruction> parseRML(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"string");
        Object object = cache.get((Object)string);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"get(...)");
        return (List)object;
    }

    static {
        parser.injectDefault();
    }
}

