/*
 * Decompiled with CFR 0.152.
 */
package com.github.nyuppo.config;

import com.github.nyuppo.MoreMobVariants;
import com.github.nyuppo.config.VariantBlacklist;
import com.github.nyuppo.config.VariantSettings;
import com.github.nyuppo.util.BreedingResultData;
import com.github.nyuppo.util.VariantBag;
import com.github.nyuppo.variant.BreedingResultModifier;
import com.github.nyuppo.variant.CustomEyesModifier;
import com.github.nyuppo.variant.CustomVariantNameModifier;
import com.github.nyuppo.variant.CustomWoolModifier;
import com.github.nyuppo.variant.DiscardableModifier;
import com.github.nyuppo.variant.MobVariant;
import com.github.nyuppo.variant.MoonPhaseModifier;
import com.github.nyuppo.variant.NametagOverrideModifier;
import com.github.nyuppo.variant.ShearedWoolColorModifier;
import com.github.nyuppo.variant.ShinyModifier;
import com.github.nyuppo.variant.SpawnableBiomesModifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import org.jetbrains.annotations.Nullable;

public class Variants {
    private static HashMap<EntityType<?>, ArrayList<MobVariant>> variants = new HashMap();
    private static HashMap<EntityType<?>, ArrayList<MobVariant>> nametagOverrides = new HashMap();
    private static HashMap<EntityType<?>, ArrayList<MobVariant>> defaultVariants;

    public static void addVariant(EntityType<?> mob, MobVariant variant) {
        if (variants.get(mob) == null) {
            variants.put(mob, new ArrayList());
        }
        if (variant.isNametagOverride()) {
            if (nametagOverrides.get(mob) == null) {
                nametagOverrides.put(mob, new ArrayList());
            }
            nametagOverrides.get(mob).add(variant);
        } else {
            variants.get(mob).add(variant);
        }
    }

    public static ArrayList<MobVariant> getVariants(EntityType<?> mob) {
        if (variants.get(mob) != null) {
            return new ArrayList<MobVariant>((Collection)variants.get(mob));
        }
        return new ArrayList<MobVariant>((Collection)defaultVariants.get(mob));
    }

    public static ArrayList<MobVariant> getNametagOverrides(EntityType<?> mob) {
        if (nametagOverrides.get(mob) != null) {
            return new ArrayList<MobVariant>((Collection)nametagOverrides.get(mob));
        }
        return new ArrayList<MobVariant>();
    }

    public static ArrayList<MobVariant> getDefaultVariants(EntityType<?> mob) {
        return new ArrayList<MobVariant>((Collection)defaultVariants.get(mob));
    }

    public static HashMap<EntityType<?>, ArrayList<MobVariant>> getAllVariants() {
        return variants;
    }

    public static HashMap<EntityType<?>, ArrayList<MobVariant>> getAllDefaultVariants() {
        return defaultVariants;
    }

    public static MobVariant getDefaultVariant(EntityType<?> mob) {
        ArrayList<MobVariant> variants = Variants.getVariants(mob);
        for (MobVariant variant : variants) {
            if (!variant.getIdentifier().equals((Object)MoreMobVariants.id("default"))) continue;
            return variant;
        }
        if (mob == EntityType.f_20553_) {
            return new MobVariant(new ResourceLocation("tabby"), 1);
        }
        return new MobVariant(MoreMobVariants.id("default"), 1);
    }

    public static MobVariant getVariant(EntityType<?> mob, ResourceLocation identifier) {
        ArrayList<MobVariant> variants = Variants.getVariants(mob);
        for (MobVariant variant : variants) {
            if (!variant.getIdentifier().equals((Object)identifier)) continue;
            return variant;
        }
        return Variants.getDefaultVariant(mob);
    }

    @Nullable
    public static MobVariant getVariantNullable(EntityType<?> mob, ResourceLocation identifier) {
        ArrayList<MobVariant> variants = Variants.getVariants(mob);
        for (MobVariant variant : variants) {
            if (!variant.getIdentifier().equals((Object)identifier)) continue;
            return variant;
        }
        return null;
    }

    public static void resetVariants(EntityType<?> mob) {
        variants.remove(mob);
        variants.put(mob, defaultVariants.get(mob));
    }

    public static void clearVariants(EntityType<?> mob) {
        variants.remove(mob);
        variants.put(mob, new ArrayList());
    }

    public static void clearAllVariants() {
        variants.clear();
        nametagOverrides.clear();
    }

    public static void validateEmptyVariants() {
        if (!variants.keySet().isEmpty()) {
            variants.keySet().forEach(mob -> {
                if (variants.get(mob).isEmpty()) {
                    Variants.resetVariants(mob);
                }
            });
        }
    }

    public static void applyBlacklists() {
        variants.keySet().forEach(mob -> {
            List variantsList = variants.get(mob);
            if (variantsList.isEmpty()) {
                return;
            }
            Iterator i = variantsList.iterator();
            while (i.hasNext()) {
                MobVariant variant = (MobVariant)i.next();
                if (!VariantBlacklist.isBlacklisted(mob, variant.getIdentifier())) continue;
                i.remove();
            }
        });
    }

    public static EntityType<?> getMob(String mobId) {
        Optional entityType = EntityType.m_20632_((String)mobId);
        if (entityType.isPresent()) {
            return (EntityType)entityType.get();
        }
        throw new IllegalArgumentException("Unknown mob identifier: " + mobId);
    }

    public static MobVariant getRandomVariant(EntityType<?> mob, long randomSeed, @Nullable Holder<Biome> spawnBiome, @Nullable BreedingResultData breedingResultData, @Nullable Float moonSize) {
        ArrayList<MobVariant> variants = Variants.getVariants(mob);
        if (variants.isEmpty()) {
            return Variants.getDefaultVariant(mob);
        }
        LegacyRandomSource random = new LegacyRandomSource(randomSeed);
        Iterator<MobVariant> i = variants.iterator();
        while (i.hasNext()) {
            MobVariant variant = i.next();
            if (spawnBiome != null && variant.hasSpawnableBiomeModifier() && !variant.isInSpawnBiome(spawnBiome)) {
                i.remove();
                continue;
            }
            if (variant.hasBreedingResultModifier()) {
                i.remove();
                continue;
            }
            if (variant.shouldDiscard((RandomSource)random)) {
                i.remove();
                continue;
            }
            if (variant.isNametagOverride()) {
                i.remove();
                continue;
            }
            if (moonSize == null || !variant.hasMinimumMoonSize() || variant.meetsMinimumMoonSize(moonSize.floatValue())) continue;
            i.remove();
        }
        VariantBag bag = new VariantBag(mob, variants);
        if (breedingResultData != null) {
            ArrayList<MobVariant> possibleVariants = new ArrayList<MobVariant>();
            for (MobVariant v : Variants.getVariants(mob)) {
                if (!v.hasBreedingResultModifier() || !v.canBreed(breedingResultData.parent1(), breedingResultData.parent2()) || !v.shouldBreed((RandomSource)random)) continue;
                possibleVariants.add(v);
            }
            if (possibleVariants.isEmpty()) {
                if (random.m_188500_() >= VariantSettings.getChildRandomVariantChance()) {
                    return random.m_188499_() ? breedingResultData.parent1() : breedingResultData.parent2();
                }
            } else {
                bag = new VariantBag(mob, possibleVariants);
            }
        }
        return bag.getRandomEntry((RandomSource)random);
    }

    @Nullable
    public static MobVariant getVariantFromNametag(EntityType<?> mob, String nametag) {
        ArrayList<MobVariant> nametagOverrides = Variants.getNametagOverrides(mob);
        if (!nametagOverrides.isEmpty()) {
            for (MobVariant mv : nametagOverrides) {
                if (!mv.getNametagOverride().equalsIgnoreCase(nametag)) continue;
                return mv;
            }
        }
        return null;
    }

    public static MobVariant getChildVariant(EntityType<?> mob, ServerLevel world, AgeableMob parent1, AgeableMob parent2) {
        CompoundTag parent1Nbt = new CompoundTag();
        parent1.m_20240_(parent1Nbt);
        CompoundTag parent2Nbt = new CompoundTag();
        parent2.m_20240_(parent2Nbt);
        if (parent1Nbt.m_128441_("VariantID") && parent2Nbt.m_128441_("VariantID")) {
            String[] parent1VariantId = parent1Nbt.m_128461_("VariantID").split(":");
            MobVariant parent1Variant = Variants.getVariant(mob, new ResourceLocation(parent1VariantId[0], parent1VariantId[1]));
            String[] parent2VariantId = parent2Nbt.m_128461_("VariantID").split(":");
            MobVariant parent2Variant = Variants.getVariant(mob, new ResourceLocation(parent2VariantId[0], parent2VariantId[1]));
            return Variants.getRandomVariant(mob, world.m_213780_().m_188505_(), (Holder<Biome>)world.m_204166_(parent1.m_20183_()), new BreedingResultData(parent1Variant, parent2Variant), null);
        }
        return Variants.getRandomVariant(mob, world.m_213780_().m_188505_(), (Holder<Biome>)world.m_204166_(parent1.m_20183_()), null, null);
    }

    public static String[] splitVariant(String namespacedVariant) {
        String[] split = namespacedVariant.split(":");
        if (split.length == 1) {
            MoreMobVariants.LOGGER.warn("Passed in non-namespaced variant id '" + namespacedVariant + "'. Auto-assigning to moremobvariants:" + namespacedVariant);
            return new String[]{"moremobvariants", split[0]};
        }
        return split;
    }

    static {
        nametagOverrides.put(EntityType.f_20520_, new ArrayList<MobVariant>(List.of(new MobVariant(MoreMobVariants.id("rainbow"), 0).addModifier(new CustomWoolModifier()).addModifier(new NametagOverrideModifier("rainbow")))));
        defaultVariants = new HashMap();
        defaultVariants.put(EntityType.f_20553_, new ArrayList<MobVariant>(List.of(new MobVariant(new ResourceLocation("all_black"), 1).addModifier(new MoonPhaseModifier(0.9f)), new MobVariant(new ResourceLocation("black"), 1), new MobVariant(new ResourceLocation("british_shorthair"), 1), new MobVariant(new ResourceLocation("calico"), 1), new MobVariant(new ResourceLocation("jellie"), 1), new MobVariant(new ResourceLocation("persian"), 1), new MobVariant(new ResourceLocation("ragdoll"), 1), new MobVariant(new ResourceLocation("red"), 1), new MobVariant(new ResourceLocation("siamese"), 1), new MobVariant(new ResourceLocation("tabby"), 1), new MobVariant(new ResourceLocation("white"), 1), new MobVariant(MoreMobVariants.id("doug"), 1), new MobVariant(MoreMobVariants.id("gray_tabby"), 1), new MobVariant(MoreMobVariants.id("handsome"), 1), new MobVariant(MoreMobVariants.id("tortoiseshell"), 1))));
        defaultVariants.put(EntityType.f_20555_, new ArrayList<MobVariant>(List.of(new MobVariant(MoreMobVariants.id("midnight"), 1), new MobVariant(MoreMobVariants.id("amber"), 2), new MobVariant(MoreMobVariants.id("gold_crested"), 2), new MobVariant(MoreMobVariants.id("bronzed"), 2), new MobVariant(MoreMobVariants.id("skewbald"), 2), new MobVariant(MoreMobVariants.id("stormy"), 2), new MobVariant(MoreMobVariants.id("bone"), 2).addModifier(new SpawnableBiomesModifier((TagKey<Biome>)BiomeTags.f_207612_)), new MobVariant(MoreMobVariants.id("duck"), 1).addModifier(new ShinyModifier()).addModifier(new DiscardableModifier(0.75)), new MobVariant(MoreMobVariants.id("default"), 3))));
        defaultVariants.put(EntityType.f_20557_, new ArrayList<MobVariant>(List.of(new MobVariant(MoreMobVariants.id("umbra"), 1), new MobVariant(MoreMobVariants.id("ashen"), 2), new MobVariant(MoreMobVariants.id("cookie"), 2), new MobVariant(MoreMobVariants.id("dairy"), 2), new MobVariant(MoreMobVariants.id("pinto"), 2), new MobVariant(MoreMobVariants.id("sunset"), 2), new MobVariant(MoreMobVariants.id("wooly"), 2), new MobVariant(MoreMobVariants.id("albino"), 1).addModifier(new ShinyModifier()).addModifier(new DiscardableModifier(0.9)).addModifier(new SpawnableBiomesModifier((TagKey<Biome>)BiomeTags.f_207609_)), new MobVariant(MoreMobVariants.id("cream"), 1).addModifier(new ShinyModifier()).addModifier(new DiscardableModifier(0.8)), new MobVariant(MoreMobVariants.id("default"), 3))));
        defaultVariants.put(EntityType.f_20510_, new ArrayList<MobVariant>(List.of(new MobVariant(MoreMobVariants.id("mottled"), 1), new MobVariant(MoreMobVariants.id("piebald"), 1), new MobVariant(MoreMobVariants.id("pink_footed"), 1), new MobVariant(MoreMobVariants.id("sooty"), 1), new MobVariant(MoreMobVariants.id("spotted"), 1), new MobVariant(MoreMobVariants.id("default"), 2))));
        defaultVariants.put(EntityType.f_20520_, new ArrayList<MobVariant>(List.of(new MobVariant(MoreMobVariants.id("fuzzy"), 2).addModifier(new CustomWoolModifier()).addModifier(new ShearedWoolColorModifier()), new MobVariant(MoreMobVariants.id("inky"), 1).addModifier(new CustomWoolModifier()).addModifier(new ShearedWoolColorModifier()), new MobVariant(MoreMobVariants.id("long_nosed"), 1).addModifier(new CustomWoolModifier()).addModifier(new ShearedWoolColorModifier()), new MobVariant(MoreMobVariants.id("patched"), 2).addModifier(new CustomWoolModifier()).addModifier(new ShearedWoolColorModifier()), new MobVariant(MoreMobVariants.id("rocky"), 2).addModifier(new CustomWoolModifier()).addModifier(new ShearedWoolColorModifier()), new MobVariant(MoreMobVariants.id("default"), 4).addModifier(new ShearedWoolColorModifier()))));
        defaultVariants.put(EntityType.f_20524_, new ArrayList<MobVariant>(List.of(new MobVariant(MoreMobVariants.id("dungeons"), 3), new MobVariant(MoreMobVariants.id("weathered"), 2), new MobVariant(MoreMobVariants.id("sandy"), 1), new MobVariant(MoreMobVariants.id("mossy"), 2).addModifier(new SpawnableBiomesModifier(MoreMobVariants.SPAWN_MOSSY_SKELETONS)), new MobVariant(MoreMobVariants.id("sandy_increased_spawns_in_deserts"), 3).addModifier(new SpawnableBiomesModifier(MoreMobVariants.INCREASED_SANDY_SKELETONS)).addModifier(new CustomVariantNameModifier("sandy")), new MobVariant(MoreMobVariants.id("default"), 4))));
        defaultVariants.put(EntityType.f_20479_, new ArrayList<MobVariant>(List.of(new MobVariant(MoreMobVariants.id("bone"), 1).addModifier(new ShinyModifier()).addModifier(new DiscardableModifier(0.8)).addModifier(new CustomEyesModifier()), new MobVariant(MoreMobVariants.id("brown"), 3).addModifier(new CustomEyesModifier()), new MobVariant(MoreMobVariants.id("tarantula"), 2), new MobVariant(MoreMobVariants.id("black_widow"), 1), new MobVariant(MoreMobVariants.id("default"), 5))));
        defaultVariants.put(EntityType.f_20499_, new ArrayList<MobVariant>(List.of(new MobVariant(MoreMobVariants.id("pale"), 1).addModifier(new SpawnableBiomesModifier(MoreMobVariants.SPAWN_PALE_WOLF)), new MobVariant(MoreMobVariants.id("rusty"), 1).addModifier(new SpawnableBiomesModifier(MoreMobVariants.SPAWN_RUSTY_WOLF)), new MobVariant(MoreMobVariants.id("spotted"), 1).addModifier(new SpawnableBiomesModifier(MoreMobVariants.SPAWN_SPOTTED_WOLF)), new MobVariant(MoreMobVariants.id("black"), 1).addModifier(new SpawnableBiomesModifier(MoreMobVariants.SPAWN_BLACK_WOLF)), new MobVariant(MoreMobVariants.id("striped"), 1).addModifier(new SpawnableBiomesModifier(MoreMobVariants.SPAWN_STRIPED_WOLF)), new MobVariant(MoreMobVariants.id("snowy"), 1).addModifier(new SpawnableBiomesModifier(MoreMobVariants.SPAWN_SNOWY_WOLF)), new MobVariant(MoreMobVariants.id("ashen"), 1).addModifier(new SpawnableBiomesModifier(MoreMobVariants.SPAWN_ASHEN_WOLF)), new MobVariant(MoreMobVariants.id("woods"), 1).addModifier(new SpawnableBiomesModifier(MoreMobVariants.SPAWN_WOODS_WOLF)), new MobVariant(MoreMobVariants.id("chestnut"), 1).addModifier(new SpawnableBiomesModifier(MoreMobVariants.SPAWN_CHESTNUT_WOLF)), new MobVariant(MoreMobVariants.id("skeleton"), 1).addModifier(new SpawnableBiomesModifier((TagKey<Biome>)BiomeTags.f_207612_)), new MobVariant(MoreMobVariants.id("basenji_from_jupiter_golden_retriever"), 1).addModifier(new CustomVariantNameModifier("basenji")).addModifier(new BreedingResultModifier(MoreMobVariants.id("jupiter"), MoreMobVariants.id("golden_retriever"), 0.5)), new MobVariant(MoreMobVariants.id("basenji_from_rusty_ashen"), 1).addModifier(new CustomVariantNameModifier("basenji")).addModifier(new BreedingResultModifier(MoreMobVariants.id("rusty"), MoreMobVariants.id("ashen"), 0.5)), new MobVariant(MoreMobVariants.id("french_bulldog_from_husky_golden_retriever"), 1).addModifier(new CustomVariantNameModifier("french_bulldog")).addModifier(new BreedingResultModifier(MoreMobVariants.id("husky"), MoreMobVariants.id("golden_retriever"), 0.5)), new MobVariant(MoreMobVariants.id("french_bulldog_from_rusty_golden_retriever"), 1).addModifier(new CustomVariantNameModifier("french_bulldog")).addModifier(new BreedingResultModifier(MoreMobVariants.id("rusty"), MoreMobVariants.id("golden_retriever"), 0.5)), new MobVariant(MoreMobVariants.id("german_shepherd_from_jupiter_husky"), 1).addModifier(new CustomVariantNameModifier("german_shepherd")).addModifier(new BreedingResultModifier(MoreMobVariants.id("jupiter"), MoreMobVariants.id("husky"), 0.5)), new MobVariant(MoreMobVariants.id("german_shepherd_from_woods_chestnut"), 1).addModifier(new CustomVariantNameModifier("german_shepherd")).addModifier(new BreedingResultModifier(MoreMobVariants.id("woods"), MoreMobVariants.id("chestnut"), 0.5)), new MobVariant(MoreMobVariants.id("golden_retriever_from_jupiter_pale"), 1).addModifier(new CustomVariantNameModifier("golden_retriever")).addModifier(new BreedingResultModifier(MoreMobVariants.id("jupiter"), MoreMobVariants.id("pale"), 0.5)), new MobVariant(MoreMobVariants.id("golden_retriever_from_rusty_pale"), 1).addModifier(new CustomVariantNameModifier("golden_retriever")).addModifier(new BreedingResultModifier(MoreMobVariants.id("rusty"), MoreMobVariants.id("pale"), 0.5)), new MobVariant(MoreMobVariants.id("husky_from_black_ashen"), 1).addModifier(new CustomVariantNameModifier("husky")).addModifier(new BreedingResultModifier(MoreMobVariants.id("black"), MoreMobVariants.id("ashen"), 0.5)), new MobVariant(MoreMobVariants.id("husky_from_snowy_ashen"), 1).addModifier(new CustomVariantNameModifier("husky")).addModifier(new BreedingResultModifier(MoreMobVariants.id("snowy"), MoreMobVariants.id("ashen"), 0.5)), new MobVariant(MoreMobVariants.id("jupiter_from_rusty_chestnut"), 1).addModifier(new CustomVariantNameModifier("jupiter")).addModifier(new BreedingResultModifier(MoreMobVariants.id("rusty"), MoreMobVariants.id("chestnut"), 0.5)), new MobVariant(MoreMobVariants.id("jupiter_from_rusty_woods"), 1).addModifier(new CustomVariantNameModifier("jupiter")).addModifier(new BreedingResultModifier(MoreMobVariants.id("rusty"), MoreMobVariants.id("woods"), 0.5)), new MobVariant(MoreMobVariants.id("jupiter_from_striped_woods"), 1).addModifier(new CustomVariantNameModifier("jupiter")).addModifier(new BreedingResultModifier(MoreMobVariants.id("striped"), MoreMobVariants.id("woods"), 0.5)))));
        defaultVariants.put(EntityType.f_20501_, new ArrayList<MobVariant>(List.of(new MobVariant(MoreMobVariants.id("alex"), 2), new MobVariant(MoreMobVariants.id("ari"), 1), new MobVariant(MoreMobVariants.id("efe"), 1), new MobVariant(MoreMobVariants.id("kai"), 1), new MobVariant(MoreMobVariants.id("makena"), 1), new MobVariant(MoreMobVariants.id("noor"), 1), new MobVariant(MoreMobVariants.id("sunny"), 1), new MobVariant(MoreMobVariants.id("zuri"), 1), new MobVariant(MoreMobVariants.id("default"), 3))));
    }
}

