/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.mantle.client.screen.book;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.FontManager;
import net.minecraft.client.gui.font.FontSet;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import org.joml.Vector3f;
import org.joml.Vector4f;
import slimeknights.mantle.client.book.data.BookData;
import slimeknights.mantle.client.book.data.PageData;
import slimeknights.mantle.client.book.data.SectionData;
import slimeknights.mantle.client.screen.book.ArrowButton;
import slimeknights.mantle.client.screen.book.ILayerRenderFunction;
import slimeknights.mantle.client.screen.book.element.BookElement;

public class BookScreen
extends Screen {
    public static boolean debug = false;
    public static final int TEX_SIZE = 512;
    public static final int PAGE_MARGIN = 8;
    public static final int PAGE_PADDING_TOP = 4;
    public static final int PAGE_PADDING_BOT = 4;
    public static final int PAGE_PADDING_LEFT = 8;
    public static final int PAGE_PADDING_RIGHT = 0;
    public static final float PAGE_SCALE = 1.0f;
    public static final int PAGE_WIDTH_UNSCALED = 206;
    public static final int PAGE_HEIGHT_UNSCALED = 200;
    public static final int PAGE_WIDTH = 182;
    public static final int PAGE_HEIGHT = 176;
    @Nullable
    private static Font uniformFont;
    @Nullable
    private static Font altFont;
    public boolean drawArrows = true;
    public boolean mouseInput = true;
    private ArrowButton previousArrow;
    private ArrowButton nextArrow;
    private ArrowButton backArrow;
    private ArrowButton indexArrow;
    public final BookData book;
    @Nullable
    private final Consumer<String> pageUpdater;
    @Nullable
    private final Consumer<?> bookPickup;
    private int page = -1;
    private int oldPage = -2;
    private final ArrayList<BookElement> leftElements = new ArrayList();
    private final ArrayList<BookElement> rightElements = new ArrayList();
    public AdvancementCache advancementCache;
    private double[] lastClick;
    private double[] lastDrag;
    private static final ILayerRenderFunction[] LAYERS;

    public BookScreen(Component title, BookData book, String page, @Nullable Consumer<String> pageUpdater, @Nullable Consumer<?> bookPickup) {
        super(title);
        this.book = book;
        this.pageUpdater = pageUpdater;
        this.bookPickup = bookPickup;
        this.f_96541_ = Minecraft.m_91087_();
        this.f_96547_ = this.f_96541_.f_91062_;
        this.advancementCache = new AdvancementCache();
        if (this.f_96541_.f_91074_ != null) {
            this.f_96541_.f_91074_.f_108617_.m_105145_().m_104397_((ClientAdvancements.Listener)this.advancementCache);
        }
        this.openPage(book.findPageNumber(page, this.advancementCache));
    }

    public static Font getAltFont() {
        if (altFont == null) {
            FontManager resourceManager = Minecraft.m_91087_().f_91045_;
            altFont = new Font(rl -> (FontSet)resourceManager.f_94999_.get(Minecraft.f_91059_), false);
        }
        return altFont;
    }

    public static Font getUniformFont() {
        if (uniformFont == null) {
            FontManager resourceManager = Minecraft.m_91087_().f_91045_;
            uniformFont = new Font(rl -> (FontSet)resourceManager.f_94999_.get(Minecraft.f_91058_), false);
        }
        return uniformFont;
    }

    public Font getFontRenderer() {
        Font fontRenderer = this.book.fontRenderer;
        if (fontRenderer == null) {
            fontRenderer = Objects.requireNonNull(this.f_96541_).f_91062_;
        }
        return fontRenderer;
    }

    private Vector3f splitRGB(int color) {
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        return new Vector3f(r, g, b);
    }

    private Vector4f splitRGBA(int color) {
        float r = (float)FastColor.ARGB32.m_13665_((int)color) / 255.0f;
        float g = (float)FastColor.ARGB32.m_13667_((int)color) / 255.0f;
        float b = (float)FastColor.ARGB32.m_13669_((int)color) / 255.0f;
        float a = (float)FastColor.ARGB32.m_13655_((int)color) / 255.0f;
        return new Vector4f(r, g, b, a);
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.f_96541_ == null) {
            return;
        }
        Font fontRenderer = this.getFontRenderer();
        if (debug) {
            int n = fontRenderer.m_92895_("DEBUG") + 4;
            Objects.requireNonNull(fontRenderer);
            graphics.m_280509_(0, 0, n, 9 + 4, 0x55000000);
            graphics.m_280056_(this.f_96547_, "DEBUG", 2, 2, -1, false);
        }
        RenderSystem.setShader(GameRenderer::m_172817_);
        RenderSystem.enableBlend();
        Vector3f coverColor = this.splitRGB(this.book.appearance.coverColor);
        if (this.page == -1) {
            this.renderCover(graphics, coverColor);
        } else {
            PoseStack matrixStack = graphics.m_280168_();
            boolean renderLeft = this.shouldRenderPage(this.page, false);
            boolean renderRight = this.shouldRenderPage(this.page, true);
            this.renderUnderLayer(graphics, coverColor);
            if (renderLeft) {
                this.renderPageBackground(graphics, false);
            }
            if (renderRight) {
                this.renderPageBackground(graphics, true);
            }
            if (this.book.appearance.drawPageNumbers) {
                String pNum;
                if (renderLeft) {
                    pNum = "" + this.page * 2;
                    matrixStack.m_85836_();
                    this.drawerTransform(matrixStack, false);
                    graphics.drawString(fontRenderer, pNum, (float)(182 - fontRenderer.m_92895_(pNum)) / 2.0f, 166.0f, -5592406, false);
                    matrixStack.m_85849_();
                }
                if (renderRight) {
                    pNum = "" + (this.page * 2 + 1);
                    matrixStack.m_85836_();
                    this.drawerTransform(matrixStack, true);
                    graphics.drawString(fontRenderer, pNum, (float)(182 - fontRenderer.m_92895_(pNum)) / 2.0f, 166.0f, -5592406, false);
                    matrixStack.m_85849_();
                }
            }
            int leftMX = this.getMouseX(false);
            int rightMX = this.getMouseX(true);
            int mY = this.getMouseY();
            for (ILayerRenderFunction layer : LAYERS) {
                if (renderLeft) {
                    matrixStack.m_85836_();
                    this.drawerTransform(matrixStack, false);
                    matrixStack.m_85841_(1.0f, 1.0f, 1.0f);
                    this.renderPageLayer(graphics, leftMX, mY, partialTicks, this.leftElements, layer);
                    matrixStack.m_85849_();
                }
                if (!renderRight) continue;
                matrixStack.m_85836_();
                this.drawerTransform(matrixStack, true);
                matrixStack.m_85841_(1.0f, 1.0f, 1.0f);
                this.renderPageLayer(graphics, rightMX, mY, partialTicks, this.rightElements, layer);
                matrixStack.m_85849_();
            }
        }
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
    }

    private boolean shouldRenderPage(int pageNum, boolean rightSide) {
        if (!rightSide) {
            return pageNum != 0;
        }
        int fullPageCount = this.book.getFullPageCount(this.advancementCache);
        return this.page < fullPageCount - 1 || this.book.getPageCount(this.advancementCache) % 2 != 0;
    }

    private void renderCover(GuiGraphics graphics, Vector3f coverColor) {
        float scale;
        int width;
        Font fontRenderer = this.getFontRenderer();
        ResourceLocation cover = this.book.appearance.getCoverTexture();
        int centerX = this.f_96543_ / 2 - 103;
        int centerY = this.f_96544_ / 2 - 100;
        RenderSystem.setShaderColor((float)coverColor.x(), (float)coverColor.y(), (float)coverColor.z(), (float)1.0f);
        graphics.m_280163_(cover, centerX, centerY, 0.0f, 0.0f, 206, 200, 512, 512);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        PoseStack matrixStack = graphics.m_280168_();
        if (!this.book.appearance.title.isEmpty()) {
            graphics.m_280163_(cover, centerX, centerY, 0.0f, 200.0f, 206, 200, 512, 512);
            matrixStack.m_85836_();
            width = this.f_96547_.m_92895_(this.book.appearance.title);
            scale = Mth.m_14036_((float)(182.0f / (float)width), (float)0.0f, (float)2.5f);
            matrixStack.m_85841_(scale, scale, 1.0f);
            String string = this.book.appearance.title;
            int n = (int)((float)this.f_96543_ / 2.0f / scale + 3.0f - (float)width / 2.0f);
            float f = (float)this.f_96544_ / 2.0f;
            Objects.requireNonNull(fontRenderer);
            graphics.m_280056_(this.f_96547_, string, n, (int)((f - 9.0f / 2.0f) / scale - 4.0f), this.book.appearance.getCoverTextColor(), true);
            matrixStack.m_85849_();
        }
        if (!this.book.appearance.subtitle.isEmpty()) {
            matrixStack.m_85836_();
            width = this.f_96547_.m_92895_(this.book.appearance.subtitle);
            scale = Mth.m_14036_((float)(182.0f / (float)width), (float)0.0f, (float)1.5f);
            matrixStack.m_85841_(scale, scale, 1.0f);
            String string = this.book.appearance.subtitle;
            int n = (int)((float)this.f_96543_ / 2.0f / scale + 7.0f - (float)width / 2.0f);
            float f = (float)this.f_96544_ / 2.0f + 100.0f;
            Objects.requireNonNull(fontRenderer);
            graphics.m_280056_(this.f_96547_, string, n, (int)((f - (float)(9 * 2)) / scale), this.book.appearance.getCoverTextColor(), true);
            matrixStack.m_85849_();
        }
    }

    private void renderUnderLayer(GuiGraphics graphics, Vector3f coverColor) {
        graphics.m_280246_(coverColor.x(), coverColor.y(), coverColor.z(), 1.0f);
        graphics.m_280163_(this.book.appearance.getBookTexture(), this.f_96543_ / 2 - 206, this.f_96544_ / 2 - 100, 0.0f, 0.0f, 412, 200, 512, 512);
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderPageBackground(GuiGraphics graphics, boolean rightSide) {
        Vector3f pageTint = this.splitRGB(this.book.appearance.getPageTint());
        graphics.m_280246_(pageTint.x(), pageTint.y(), pageTint.z(), 1.0f);
        if (!rightSide) {
            graphics.m_280163_(this.book.appearance.getBookTexture(), this.f_96543_ / 2 - 206, this.f_96544_ / 2 - 100, 0.0f, 200.0f, 206, 200, 512, 512);
        } else {
            graphics.m_280163_(this.book.appearance.getBookTexture(), this.f_96543_ / 2, this.f_96544_ / 2 - 100, 206.0f, 200.0f, 206, 200, 512, 512);
        }
        graphics.m_280246_(1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderPageLayer(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks, List<BookElement> elements, ILayerRenderFunction layerFunc) {
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)this.book.appearance.getCoverTexture());
        Font font = this.getFontRenderer();
        for (BookElement element : elements) {
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            layerFunc.draw(element, graphics, mouseX, mouseY, partialTicks, font);
        }
    }

    protected void m_7856_() {
        super.m_7856_();
        this.m_169413_();
        this.previousArrow = (ArrowButton)this.m_142416_((GuiEventListener)new ArrowButton(this.book, 50, -50, ArrowButton.ArrowType.PREV, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            --this.page;
            if (this.page < -1) {
                this.page = -1;
            }
            this.oldPage = -2;
            this.buildPages();
        }));
        this.nextArrow = (ArrowButton)this.m_142416_((GuiEventListener)new ArrowButton(this.book, -50, -50, ArrowButton.ArrowType.NEXT, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            ++this.page;
            int fullPageCount = this.book.getFullPageCount(this.advancementCache);
            if (this.page >= fullPageCount) {
                this.page = fullPageCount - 1;
            }
            this.oldPage = -2;
            this.buildPages();
        }));
        this.backArrow = (ArrowButton)this.m_142416_((GuiEventListener)new ArrowButton(this.book, this.f_96543_ / 2 - 9, this.f_96544_ / 2 + 5 + 88, ArrowButton.ArrowType.LEFT, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            if (this.oldPage >= -1) {
                this.page = this.oldPage;
            }
            this.oldPage = -2;
            this.buildPages();
        }));
        this.indexArrow = (ArrowButton)this.m_142416_((GuiEventListener)new ArrowButton(this.book, this.f_96543_ / 2 - 206 - 9, this.f_96544_ / 2 - 100, ArrowButton.ArrowType.BACK_UP, this.book.appearance.arrowColor, this.book.appearance.arrowColorHover, p_212998_1_ -> {
            this.openPage(this.book.findPageNumber("index.page1", this.advancementCache));
            this.oldPage = -2;
            this.buildPages();
        }));
        if (this.bookPickup != null) {
            int margin = 10;
            if (this.f_96544_ / 2 + 100 + margin + 20 >= this.f_96544_) {
                margin = 0;
            }
            this.m_142416_((GuiEventListener)Button.m_253074_((Component)Component.m_237115_((String)"lectern.take_book"), button -> {
                this.m_7379_();
                this.bookPickup.accept(null);
            }).m_252794_(this.f_96543_ / 2 - 98, this.f_96544_ / 2 + 100 + margin).m_253046_(196, 20).m_253136_());
        }
        this.buildPages();
    }

    public void m_86600_() {
        super.m_86600_();
        this.previousArrow.f_93624_ = this.page != -1 && this.drawArrows;
        this.nextArrow.f_93624_ = this.page + 1 < this.book.getFullPageCount(this.advancementCache) && this.drawArrows;
        boolean bl = this.backArrow.f_93624_ = this.oldPage >= -1 && this.drawArrows;
        if (this.page == -1) {
            this.nextArrow.m_252865_(this.f_96543_ / 2 + 80);
            this.indexArrow.f_93624_ = false;
        } else {
            this.previousArrow.m_252865_(this.f_96543_ / 2 - 184);
            this.nextArrow.m_252865_(this.f_96543_ / 2 + 165);
            SectionData index = this.book.findSection("index", this.advancementCache);
            this.indexArrow.f_93624_ = index != null && (this.page - 1) * 2 + 2 > index.getPageCount() && this.drawArrows;
        }
        this.previousArrow.m_253211_(this.f_96544_ / 2 + 75);
        this.nextArrow.m_253211_(this.f_96544_ / 2 + 75);
    }

    public boolean previousPage() {
        --this.page;
        if (this.page < -1) {
            this.page = -1;
            return false;
        }
        this.oldPage = -2;
        this.buildPages();
        return true;
    }

    public boolean nextPage() {
        ++this.page;
        int fullPageCount = this.book.getFullPageCount(this.advancementCache);
        if (this.page >= fullPageCount) {
            this.page = fullPageCount - 1;
            return false;
        }
        this.oldPage = -2;
        this.buildPages();
        return true;
    }

    public boolean m_7933_(int keyCode, int scanCode, int modifiers) {
        super.m_7933_(keyCode, scanCode, modifiers);
        switch (keyCode) {
            case 65: 
            case 263: {
                this.previousPage();
                return true;
            }
            case 68: 
            case 262: {
                this.nextPage();
                return true;
            }
            case 292: {
                debug = !debug;
                return true;
            }
        }
        return super.m_7933_(keyCode, scanCode, modifiers);
    }

    public boolean m_6050_(double unKnown1, double unKnown2, double scrollDelta) {
        if (scrollDelta < 0.0) {
            this.nextPage();
            return true;
        }
        if (scrollDelta > 0.0) {
            this.previousPage();
            return true;
        }
        return super.m_6050_(scrollDelta, unKnown1, unKnown2);
    }

    public boolean m_6375_(double originalMouseX, double originalMouseY, int mouseButton) {
        boolean right = false;
        double mouseX = this.getMouseX(false);
        double mouseY = this.getMouseY();
        if (mouseX > 198.0) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        this.lastClick = new double[]{mouseX, mouseY};
        int oldPage = this.page;
        List<BookElement> elementList = List.copyOf(right ? this.rightElements : this.leftElements);
        for (BookElement element : elementList) {
            element.mouseClicked(mouseX, mouseY, mouseButton);
            if (this.page == oldPage) continue;
            return true;
        }
        return super.m_6375_(originalMouseX, originalMouseY, mouseButton);
    }

    public boolean m_6348_(double originalMouseX, double originalMouseY, int mouseButton) {
        boolean right = false;
        double mouseX = this.getMouseX(false);
        double mouseY = this.getMouseY();
        if (mouseX > 198.0) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        int i = 0;
        while (right ? i < this.rightElements.size() : i < this.leftElements.size()) {
            BookElement element = right ? this.rightElements.get(i) : this.leftElements.get(i);
            element.mouseReleased(mouseX, mouseY, mouseButton);
            ++i;
        }
        this.lastClick = null;
        this.lastDrag = null;
        return super.m_6348_(originalMouseX, originalMouseY, mouseButton);
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        boolean right = false;
        mouseX = this.getMouseX(false);
        mouseY = this.getMouseY();
        if (mouseX > 198.0) {
            mouseX = this.getMouseX(true);
            right = true;
        }
        if (this.lastClick != null) {
            if (this.lastDrag == null) {
                this.lastDrag = new double[]{mouseX, mouseY};
            }
            int i = 0;
            while (right ? i < this.rightElements.size() : i < this.leftElements.size()) {
                BookElement element = right ? this.rightElements.get(i) : this.leftElements.get(i);
                element.mouseDragged(this.lastClick[0], this.lastClick[1], mouseX, mouseY, this.lastDrag[0], this.lastDrag[1], button);
                ++i;
            }
            this.lastDrag = new double[]{mouseX, mouseY};
        }
        return true;
    }

    public void m_7861_() {
        if (this.f_96541_ == null || this.f_96541_.f_91074_ == null) {
            return;
        }
        if (this.pageUpdater != null) {
            Object pageStr = "";
            if (this.page >= 0) {
                PageData page;
                PageData pageData = page = this.page == 0 ? this.book.findPage(0, this.advancementCache) : this.book.findPage((this.page - 1) * 2 + 1, this.advancementCache);
                if (page == null) {
                    page = this.book.findPage((this.page - 1) * 2 + 2, this.advancementCache);
                }
                if (page != null && page.parent != null) {
                    pageStr = page.parent.name + "." + page.name;
                }
            }
            this.pageUpdater.accept((String)pageStr);
        }
    }

    public boolean m_7043_() {
        return false;
    }

    public void drawerTransform(PoseStack matrixStack, boolean rightSide) {
        if (rightSide) {
            matrixStack.m_252880_((float)(this.f_96543_ / 2 + 0 + 8), (float)(this.f_96544_ / 2 - 100 + 4 + 8), 0.0f);
        } else {
            matrixStack.m_252880_((float)(this.f_96543_ / 2 - 206 + 8 + 8), (float)(this.f_96544_ / 2 - 100 + 4 + 8), 0.0f);
        }
    }

    protected float leftOffset(boolean rightSide) {
        if (rightSide) {
            return this.f_96543_ / 2 + 0 + 8;
        }
        return this.f_96543_ / 2 - 206 + 8 + 8;
    }

    protected float topOffset() {
        return this.f_96544_ / 2 - 100 + 4 + 8;
    }

    protected int getMouseX(boolean rightSide) {
        assert (this.f_96541_ != null);
        if (!this.mouseInput) {
            return -1;
        }
        return (int)((Minecraft.m_91087_().f_91067_.m_91589_() * (double)this.f_96543_ / (double)this.f_96541_.m_91268_().m_85443_() - (double)this.leftOffset(rightSide)) / 1.0);
    }

    protected int getMouseY() {
        assert (this.f_96541_ != null);
        if (!this.mouseInput) {
            return -1;
        }
        return (int)((Minecraft.m_91087_().f_91067_.m_91594_() * (double)this.f_96544_ / (double)this.f_96541_.m_91268_().m_85444_() - 1.0 - (double)this.topOffset()) / 1.0);
    }

    public int openPage(int page) {
        return this.openPage(page, false);
    }

    public int openPage(int page, boolean returner) {
        if (page < 0) {
            return -1;
        }
        int bookPage = page == 1 ? 0 : (page % 2 == 0 ? (page - 1) / 2 + 1 : (page - 2) / 2 + 1);
        if (bookPage >= -1 && bookPage < this.book.getFullPageCount(this.advancementCache)) {
            if (returner) {
                this.oldPage = this.page;
            }
            this._setPage(bookPage);
        }
        return page % 2 == 0 ? 0 : 1;
    }

    public void _setPage(int page) {
        this.page = page;
        this.buildPages();
    }

    public int getPage(int side) {
        if (this.page == 0 && side == 0) {
            return -1;
        }
        if (this.page == 0 && side == 1) {
            return 0;
        }
        if (side == 0) {
            return (this.page - 1) * 2 + 1;
        }
        if (side == 1) {
            return (this.page - 2) * 2 + 2;
        }
        return -1;
    }

    public int getPage_() {
        return this.page;
    }

    public List<BookElement> getElements(int side) {
        return side == 0 ? this.leftElements : (side == 1 ? this.rightElements : Collections.emptyList());
    }

    public void openCover() {
        this._setPage(-1);
        this.leftElements.clear();
        this.rightElements.clear();
        this.buildPages();
    }

    private void buildPages() {
        this.leftElements.clear();
        this.rightElements.clear();
        if (this.page == -1) {
            return;
        }
        if (this.page == 0) {
            PageData page = this.book.findPage(0, this.advancementCache);
            if (page != null) {
                page.content.build(this.book, this.rightElements, false);
            }
        } else {
            PageData leftPage = this.book.findPage((this.page - 1) * 2 + 1, this.advancementCache);
            PageData rightPage = this.book.findPage((this.page - 1) * 2 + 2, this.advancementCache);
            if (leftPage != null) {
                leftPage.content.build(this.book, this.leftElements, false);
            }
            if (rightPage != null) {
                rightPage.content.build(this.book, this.rightElements, true);
            }
        }
        for (BookElement element : this.leftElements) {
            element.parent = this;
        }
        for (BookElement element : this.rightElements) {
            element.parent = this;
        }
    }

    static {
        LAYERS = new ILayerRenderFunction[]{BookElement::draw, BookElement::drawOverlay};
    }

    public static class AdvancementCache
    implements ClientAdvancements.Listener {
        private final HashMap<Advancement, AdvancementProgress> progress = new HashMap();
        private final HashMap<ResourceLocation, Advancement> nameCache = new HashMap();

        @Nullable
        public AdvancementProgress getProgress(String id) {
            return this.getProgress(this.getAdvancement(id));
        }

        @Nullable
        public AdvancementProgress getProgress(Advancement advancement) {
            return this.progress.get(advancement);
        }

        public Advancement getAdvancement(String id) {
            return this.nameCache.get(new ResourceLocation(id));
        }

        public void m_7922_(Advancement advancement, AdvancementProgress advancementProgress) {
            this.progress.put(advancement, advancementProgress);
        }

        public void m_6896_(@Nullable Advancement advancement) {
        }

        public void m_5513_(Advancement advancement) {
            this.nameCache.put(advancement.m_138327_(), advancement);
        }

        public void m_5504_(Advancement advancement) {
            this.progress.remove(advancement);
            this.nameCache.remove(advancement.m_138327_());
        }

        public void m_5505_(Advancement advancement) {
            this.nameCache.put(advancement.m_138327_(), advancement);
        }

        public void m_5516_(Advancement advancement) {
            this.progress.remove(advancement);
            this.nameCache.remove(advancement.m_138327_());
        }

        public void m_7204_() {
            this.progress.clear();
            this.nameCache.clear();
        }
    }
}

