/*
 * Decompiled with CFR 0.152.
 */
package net.potionstudios.biomeswevegone.world.entity.ai.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.schedule.Activity;
import net.potionstudios.biomeswevegone.world.entity.pumpkinwarden.PumpkinWarden;
import org.jetbrains.annotations.NotNull;

public class PumpkinWardenPanicTrigger
extends Behavior<PumpkinWarden> {
    private int ticks = 0;
    private long endTimestamp;

    public PumpkinWardenPanicTrigger() {
        super((Map)ImmutableMap.of());
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel level, @NotNull PumpkinWarden entity) {
        return !entity.isHiding();
    }

    protected boolean canStillUse(@NotNull ServerLevel level, @NotNull PumpkinWarden entity, long gameTime) {
        return PumpkinWardenPanicTrigger.isHurt((LivingEntity)entity) || PumpkinWardenPanicTrigger.hasHostile((LivingEntity)entity);
    }

    protected void start(@NotNull ServerLevel level, @NotNull PumpkinWarden entity, long gameTime) {
        if (PumpkinWardenPanicTrigger.isHurt((LivingEntity)entity) || PumpkinWardenPanicTrigger.hasHostile((LivingEntity)entity)) {
            Brain<PumpkinWarden> brain = entity.m_6274_();
            if (!brain.m_21954_(Activity.f_37984_)) {
                brain.m_21936_(MemoryModuleType.f_26377_);
                brain.m_21936_(MemoryModuleType.f_26370_);
                brain.m_21936_(MemoryModuleType.f_26371_);
                brain.m_21936_(MemoryModuleType.f_26374_);
            }
            brain.m_21889_(Activity.f_37984_);
        }
        this.endTimestamp = gameTime + 200L;
    }

    protected void tick(@NotNull ServerLevel level, @NotNull PumpkinWarden entity, long gameTime) {
        if (this.ticks >= 200) {
            entity.m_6274_().m_21889_(Activity.f_37987_);
            entity.hide();
            this.m_6732_(level, (LivingEntity)entity, gameTime);
        }
        ++this.ticks;
    }

    protected boolean m_7773_(long gameTime) {
        return gameTime > this.endTimestamp;
    }

    private static boolean hasHostile(LivingEntity entity) {
        return entity.m_6274_().m_21874_(MemoryModuleType.f_26323_);
    }

    private static boolean isHurt(LivingEntity entity) {
        return entity.m_6274_().m_21874_(MemoryModuleType.f_26381_);
    }
}

