/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.misc;

import de.ellpeck.prettypipes.misc.FilterSlot;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleItem;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class ItemFilter
extends ItemStackHandler {
    private final ItemStack stack;
    private final PipeBlockEntity pipe;
    public boolean isWhitelist;
    public boolean canPopulateFromInventories;
    public boolean canModifyWhitelist = true;
    private boolean modified;

    public ItemFilter(int size, ItemStack stack, PipeBlockEntity pipe) {
        super(size);
        this.stack = stack;
        this.pipe = pipe;
        this.load();
    }

    public List<Slot> getSlots(int x, int y) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = 0; i < this.getSlots(); ++i) {
            slots.add((Slot)new FilterSlot((IItemHandler)this, i, x + i % 9 * 18, y + i / 9 * 18, true));
        }
        return slots;
    }

    @OnlyIn(value=Dist.CLIENT)
    public List<AbstractWidget> getButtons(Screen gui, int x, int y, boolean rightAligned) {
        ArrayList<AbstractWidget> buttons = new ArrayList<AbstractWidget>();
        if (this.canModifyWhitelist) {
            Supplier<String> whitelistText = () -> "info.prettypipes." + (this.isWhitelist ? "whitelist" : "blacklist");
            buttons.add((AbstractWidget)Button.m_253074_((Component)Component.m_237115_((String)whitelistText.get()), button -> {
                PacketButton.sendAndExecute(this.pipe.m_58899_(), PacketButton.ButtonResult.FILTER_CHANGE, 0);
                button.m_93666_((Component)Component.m_237115_((String)((String)whitelistText.get())));
            }).m_252987_(x - 20, y, 20, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)(whitelistText.get() + ".description")).m_130940_(ChatFormatting.GRAY))).m_253136_());
        }
        if (this.canPopulateFromInventories) {
            buttons.add((AbstractWidget)Button.m_253074_((Component)Component.m_237115_((String)"info.prettypipes.populate"), button -> PacketButton.sendAndExecute(this.pipe.m_58899_(), PacketButton.ButtonResult.FILTER_CHANGE, 1)).m_252987_(x - 42, y, 20, 20).m_257505_(Tooltip.m_257550_((Component)Component.m_237115_((String)"info.prettypipes.populate.description").m_130940_(ChatFormatting.GRAY))).m_253136_());
        }
        return buttons;
    }

    public void onButtonPacket(IFilteredContainer menu, int id) {
        if (id == 0 && this.canModifyWhitelist) {
            this.isWhitelist = !this.isWhitelist;
            this.modified = true;
            this.save();
        } else if (id == 1 && this.canPopulateFromInventories) {
            boolean changed = false;
            List<ItemFilter> filters = this.pipe.getFilters(null);
            for (Direction direction : Direction.values()) {
                IItemHandler handler = this.pipe.getItemHandler(direction);
                if (handler == null) continue;
                block1: for (int i = 0; i < handler.getSlots(); ++i) {
                    ItemStack stack = handler.getStackInSlot(i);
                    if (stack.m_41619_() || this.isFiltered(stack, null)) continue;
                    ItemStack copy = stack.m_41777_();
                    copy.m_41764_(1);
                    for (ItemFilter filter : filters) {
                        if (!ItemHandlerHelper.insertItem((IItemHandler)filter, (ItemStack)copy, (boolean)false).m_41619_()) continue;
                        changed = true;
                        filter.save();
                        continue block1;
                    }
                }
            }
            if (changed) {
                menu.onFilterPopulated();
            }
        }
    }

    public boolean isAllowed(ItemStack stack, Direction direction) {
        return this.isFiltered(stack, direction) == this.isWhitelist;
    }

    private boolean isFiltered(ItemStack stack, Direction direction) {
        ItemEquality[] types = ItemFilter.getEqualityTypes(this.pipe);
        for (ItemStackHandler itemStackHandler : this.pipe.getFilters(direction)) {
            for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
                ItemStack filter = itemStackHandler.getStackInSlot(i);
                if (filter.m_41619_() || !ItemEquality.compareItems(stack, filter, types)) continue;
                return true;
            }
        }
        return false;
    }

    public void save() {
        if (this.modified) {
            this.stack.m_41784_().m_128365_("filter", (Tag)this.serializeNBT());
            this.pipe.m_6596_();
            this.modified = false;
        }
    }

    public void load() {
        if (this.stack.m_41782_()) {
            this.deserializeNBT(this.stack.m_41783_().m_128469_("filter"));
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag nbt = super.serializeNBT();
        if (this.canModifyWhitelist) {
            nbt.m_128379_("whitelist", this.isWhitelist);
        }
        return nbt;
    }

    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        if (this.canModifyWhitelist) {
            this.isWhitelist = nbt.m_128471_("whitelist");
        }
    }

    protected void onContentsChanged(int slot) {
        this.modified = true;
    }

    public static ItemEquality[] getEqualityTypes(PipeBlockEntity pipe) {
        return (ItemEquality[])pipe.streamModules().filter(m -> m.getRight() instanceof FilterModifierModuleItem).map(m -> ((FilterModifierModuleItem)m.getRight()).getEqualityType((ItemStack)m.getLeft())).toArray(ItemEquality[]::new);
    }

    public static interface IFilteredContainer {
        public ItemFilter getFilter();

        default public void onFilterPopulated() {
        }
    }
}

