/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.compat.jei;

import de.ellpeck.prettypipes.Registry;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.packets.PacketCraftingModuleTransfer;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleContainer;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.ingredient.IRecipeSlotView;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingRecipe;
import org.jetbrains.annotations.Nullable;

public class CraftingModuleTransferHandler
implements IRecipeTransferHandler<CraftingModuleContainer, CraftingRecipe> {
    public Class<CraftingModuleContainer> getContainerClass() {
        return CraftingModuleContainer.class;
    }

    public Optional<MenuType<CraftingModuleContainer>> getMenuType() {
        return Optional.of(Registry.craftingModuleContainer);
    }

    public RecipeType<CraftingRecipe> getRecipeType() {
        return RecipeTypes.CRAFTING;
    }

    @Nullable
    public IRecipeTransferError transferRecipe(CraftingModuleContainer container, CraftingRecipe recipe, IRecipeSlotsView slots, Player player, boolean maxTransfer, boolean doTransfer) {
        if (!doTransfer) {
            return null;
        }
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (IRecipeSlotView entry : slots.getSlotViews()) {
            List allIngredients = entry.getIngredients((IIngredientType)VanillaTypes.ITEM_STACK).toList();
            if (allIngredients.isEmpty()) continue;
            ItemStack remain = ((ItemStack)allIngredients.get(0)).m_41777_();
            ArrayList<ItemStack> toAdd = entry.getRole() == RecipeIngredientRole.INPUT ? inputs : outputs;
            for (ItemStack stack : toAdd) {
                if (!ItemEquality.compareItems(stack, remain, new ItemEquality[0])) continue;
                int fits = Math.min(stack.m_41741_() - stack.m_41613_(), remain.m_41613_());
                stack.m_41769_(fits);
                remain.m_41774_(fits);
                if (!remain.m_41619_()) continue;
                break;
            }
            if (remain.m_41619_()) continue;
            toAdd.add(remain);
        }
        PacketHandler.sendToServer(new PacketCraftingModuleTransfer(inputs, outputs));
        return null;
    }
}

