/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.message;

import com.github.alexmodguy.alexscaves.server.entity.util.MagnetUtil;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraftforge.network.NetworkEvent;

public class PlayerJumpFromMagnetMessage {
    private int entityID;
    private boolean jumping;

    public PlayerJumpFromMagnetMessage(int entityID, boolean jumping) {
        this.entityID = entityID;
        this.jumping = jumping;
    }

    public static PlayerJumpFromMagnetMessage read(FriendlyByteBuf buf) {
        return new PlayerJumpFromMagnetMessage(buf.readInt(), buf.readBoolean());
    }

    public static void write(PlayerJumpFromMagnetMessage message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityID);
        buf.writeBoolean(message.jumping);
    }

    public static void handle(PlayerJumpFromMagnetMessage message, Supplier<NetworkEvent.Context> context) {
        Entity entity;
        context.get().setPacketHandled(true);
        ServerPlayer player = context.get().getSender();
        if (player != null && MagnetUtil.isPulledByMagnets(entity = player.m_9236_().m_6815_(message.entityID)) && entity instanceof LivingEntity) {
            LivingEntity living = (LivingEntity)entity;
            living.f_20899_ = message.jumping;
        }
    }
}

