/*
 * Decompiled with CFR 0.152.
 */
package com.github.alexmodguy.alexscaves.server.entity.ai;

import com.github.alexmodguy.alexscaves.server.block.ACBlockRegistry;
import com.github.alexmodguy.alexscaves.server.entity.living.GumWormEntity;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.phys.Vec3;

public class GumWormDestroyGobthumperGoal
extends Goal {
    private final GumWormEntity entity;
    private int continueLeapFor = 0;

    public GumWormDestroyGobthumperGoal(GumWormEntity worm) {
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
        this.entity = worm;
    }

    public boolean m_8036_() {
        BlockPos gobthumperPos = this.entity.getGobthumperPos();
        return gobthumperPos != null && this.entity.m_9236_().m_8055_(gobthumperPos).m_60713_((Block)ACBlockRegistry.GOBTHUMPER.get()) && this.entity.m_20275_((float)gobthumperPos.m_123341_() + 0.5f, (float)gobthumperPos.m_123342_() + 0.5f, (float)gobthumperPos.m_123343_() + 0.5f) < 50000.0 && !this.entity.isRidingMode();
    }

    public boolean m_8045_() {
        return (super.m_8045_() || this.continueLeapFor > 0) && !this.entity.isRidingMode();
    }

    public void m_8056_() {
        this.continueLeapFor = 40;
    }

    public void m_8041_() {
        this.entity.setBiting(false);
        this.entity.setLeaping(false);
    }

    public void m_8037_() {
        BlockPos gobthumperPos = this.entity.getGobthumperPos();
        if (gobthumperPos != null) {
            BlockPos leapFromPos = this.getUnderGobthumperPos(gobthumperPos, this.entity.m_20186_());
            double distance = this.entity.m_20275_((float)gobthumperPos.m_123341_() + 0.5f, (float)gobthumperPos.m_123342_() + 0.5f, (float)gobthumperPos.m_123343_() + 0.5f);
            double distance2 = this.entity.m_20275_((float)leapFromPos.m_123341_() + 0.5f, (float)leapFromPos.m_123342_() + 0.5f, (float)leapFromPos.m_123343_() + 0.5f);
            if (this.entity.isLeaping()) {
                this.entity.m_21573_().m_26573_();
                if ((double)(gobthumperPos.m_123342_() + 2) > this.entity.m_20186_() && this.entity.m_5830_()) {
                    Vec3 extraDeltaHelp = Vec3.m_82512_((Vec3i)gobthumperPos).m_82546_(this.entity.m_20182_());
                    if (extraDeltaHelp.m_82553_() > 1.0) {
                        extraDeltaHelp = extraDeltaHelp.m_82541_();
                    }
                    this.entity.m_20256_(this.entity.m_20184_().m_82520_(extraDeltaHelp.f_82479_ * (double)0.2f, (double)0.4f, extraDeltaHelp.f_82481_ * (double)0.2f));
                }
            } else if (Math.min(distance2, distance) < 8.0) {
                this.entity.m_21573_().m_26573_();
                this.entity.setLeaping(true);
            } else if (!this.entity.isLeaping()) {
                if (this.entity.m_9236_().m_8055_(this.entity.m_20183_()).m_60795_()) {
                    this.entity.m_20256_(this.entity.m_20184_().m_82520_(0.0, (double)-0.3f, 0.0));
                }
                this.entity.m_21573_().m_26519_((double)((float)leapFromPos.m_123341_() + 0.5f), (double)((float)leapFromPos.m_123342_() + 0.5f), (double)((float)leapFromPos.m_123343_() + 0.5f), 1.0);
            }
            if (this.entity.isLeaping() && distance < 20.0) {
                this.entity.attemptPlayAttackNoise();
                Vec3 leapDelta = new Vec3(0.0, (double)-0.2f, 1.0).m_82524_((float)(-Math.toRadians(this.entity.f_20883_)));
                this.entity.m_9236_().m_46961_(gobthumperPos, false);
                this.entity.setGobthumperPos(null);
                this.entity.m_20256_(this.entity.m_20184_().m_82549_(leapDelta));
            }
            if (distance < 40.0) {
                this.entity.setBiting(true);
            }
            if (distance < 200.0) {
                Vec3 wiggleExtraVec = gobthumperPos.m_252807_().m_82546_(this.entity.m_20182_()).m_82541_().m_82490_((double)0.1f);
                this.entity.m_20256_(this.entity.m_20184_().m_82549_(wiggleExtraVec));
            }
        } else if (this.continueLeapFor > 0 && this.entity.isLeaping()) {
            --this.continueLeapFor;
            Vec3 leapDelta = new Vec3(0.0, this.continueLeapFor < 24 ? (double)-0.3f : (double)0.1f, (double)0.2f).m_82524_((float)(-Math.toRadians(this.entity.f_20883_)));
            this.entity.m_20256_(this.entity.m_20184_().m_82549_(leapDelta));
        }
    }

    private BlockPos getUnderGobthumperPos(BlockPos gobthumperPos, double y) {
        BlockPos.MutableBlockPos mutableBlockPos = new BlockPos.MutableBlockPos();
        mutableBlockPos.m_122169_((double)gobthumperPos.m_123341_(), Math.min((double)(gobthumperPos.m_123342_() - 1), y), (double)gobthumperPos.m_123343_());
        while (this.entity.m_9236_().m_8055_((BlockPos)mutableBlockPos).m_60795_() && (double)mutableBlockPos.m_123342_() < y || (double)mutableBlockPos.m_123342_() < y - 10.0) {
            mutableBlockPos.m_122184_(0, 1, 0);
        }
        return mutableBlockPos;
    }
}

