/*
 * Decompiled with CFR 0.152.
 */
package net.projectile_damage.client;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.projectile_damage.api.IProjectileWeapon;

public class TooltipHelper {
    public static void updateTooltipText(ItemStack itemStack, List<Component> lines) {
        if (itemStack.m_41720_() instanceof IProjectileWeapon) {
            TooltipHelper.mergeAttributeLines_MainHandOffHand(lines);
            TooltipHelper.replaceAttributeLines_BlueWithGreen(lines);
        }
    }

    private static void mergeAttributeLines_MainHandOffHand(List<Component> tooltip) {
        ArrayList<Component> heldInHandLines = new ArrayList<Component>();
        ArrayList<Component> mainHandAttributes = new ArrayList<Component>();
        ArrayList<Component> offHandAttributes = new ArrayList<Component>();
        for (int i = 0; i < tooltip.size(); ++i) {
            Component line = tooltip.get(i);
            ComponentContents content = line.m_214077_();
            if (!(content instanceof TranslatableContents)) continue;
            TranslatableContents translatableText = (TranslatableContents)content;
            if (translatableText.m_237508_().startsWith("item.modifiers")) {
                heldInHandLines.add(line);
            }
            if (!translatableText.m_237508_().startsWith("attribute.modifier")) continue;
            if (heldInHandLines.size() == 1) {
                mainHandAttributes.add(line);
            }
            if (heldInHandLines.size() != 2) continue;
            offHandAttributes.add(line);
        }
        if (heldInHandLines.size() == 2) {
            int mainHandLine = tooltip.indexOf(heldInHandLines.get(0));
            int offHandLine = tooltip.indexOf(heldInHandLines.get(1));
            tooltip.remove(mainHandLine);
            tooltip.add(mainHandLine, (Component)Component.m_237115_((String)"item.modifiers.both_hands").m_130940_(ChatFormatting.GRAY));
            tooltip.remove(offHandLine);
            for (Component offhandAttribute : offHandAttributes) {
                if (!mainHandAttributes.contains(offhandAttribute)) continue;
                tooltip.remove(tooltip.lastIndexOf(offhandAttribute));
            }
            int lastIndex = tooltip.size() - 1;
            Component lastLine = tooltip.get(lastIndex);
            if (lastLine.getString().isEmpty()) {
                tooltip.remove(lastIndex);
            }
        }
    }

    private static void replaceAttributeLines_BlueWithGreen(List<Component> tooltip) {
        String attributeTranslationKey = "attribute.name.projectile_damage.generic";
        for (int i = 0; i < tooltip.size(); ++i) {
            Component line = tooltip.get(i);
            ComponentContents content = line.m_214077_();
            if (!(content instanceof TranslatableContents)) continue;
            TranslatableContents translatable = (TranslatableContents)content;
            boolean isProjectileAttributeLine = false;
            double attributeValue = 0.0;
            if (translatable.m_237508_().startsWith("attribute.modifier.plus.0")) {
                for (Object arg : translatable.m_237523_()) {
                    TranslatableContents attributeTranslatable;
                    Component attributeText;
                    ComponentContents componentContents;
                    if (arg instanceof String) {
                        String string = (String)arg;
                        try {
                            Double number = Double.valueOf(string);
                            attributeValue = number;
                        }
                        catch (Exception number) {
                            // empty catch block
                        }
                    }
                    if (!(arg instanceof Component) || !((componentContents = (attributeText = (Component)arg).m_214077_()) instanceof TranslatableContents) || !(attributeTranslatable = (TranslatableContents)componentContents).m_237508_().startsWith(attributeTranslationKey)) continue;
                    isProjectileAttributeLine = true;
                }
            }
            if (!isProjectileAttributeLine || !(attributeValue > 0.0)) continue;
            MutableComponent greenAttributeLine = Component.m_237113_((String)" ").m_7220_((Component)Component.m_237110_((String)("attribute.modifier.equals." + AttributeModifier.Operation.ADDITION.m_22235_()), (Object[])new Object[]{ItemStack.f_41584_.format(attributeValue), Component.m_237115_((String)attributeTranslationKey)})).m_130940_(ChatFormatting.DARK_GREEN);
            tooltip.set(i, (Component)greenAttributeLine);
        }
    }
}

