/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.modernfix.forge.mixin.perf.smart_ingredient_sync;

import java.util.Optional;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.Ingredient;
import org.embeddedt.modernfix.forge.packet.PacketHandler;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={Ingredient.class})
public abstract class IngredientMixin {
    @Shadow
    @Final
    private Ingredient.Value[] f_43902_;
    @Unique
    private static final ResourceLocation MODERNFIX_TAG_VALUE = new ResourceLocation("modernfix", "tag_value");

    @Shadow
    public abstract boolean isVanilla();

    @Inject(method={"toNetwork"}, at={@At(value="HEAD")}, cancellable=true)
    private void checkForVanillaTagIngredient(FriendlyByteBuf buf, CallbackInfo ci) {
        Ingredient.Value value;
        if (!PacketHandler.CLIENT_HAS_SMART_INGREDIENT_SYNC.get().booleanValue() || !this.isVanilla()) {
            return;
        }
        Ingredient.Value[] values = this.f_43902_;
        if (values.length == 1 && (value = values[0]) instanceof Ingredient.TagValue) {
            Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
            Optional optionalHolderSet = BuiltInRegistries.f_257033_.m_203431_(tagValue.f_43959_);
            if (optionalHolderSet.isEmpty()) {
                return;
            }
            ci.cancel();
            buf.m_130130_(-1);
            buf.m_130085_(MODERNFIX_TAG_VALUE);
            buf.m_130085_(tagValue.f_43959_.f_203868_());
        }
    }

    @Inject(method={"fromNetwork"}, at={@At(value="INVOKE", target="Lnet/minecraft/network/FriendlyByteBuf;readResourceLocation()Lnet/minecraft/resources/ResourceLocation;", ordinal=0)}, cancellable=true)
    private static void deserializeModernFixTagValue(FriendlyByteBuf buffer, CallbackInfoReturnable<Ingredient> cir) {
        int readerIndex = buffer.readerIndex();
        ResourceLocation type = buffer.m_130281_();
        if (!type.equals((Object)MODERNFIX_TAG_VALUE)) {
            buffer.readerIndex(readerIndex);
            return;
        }
        ResourceLocation tag = buffer.m_130281_();
        cir.setReturnValue((Object)Ingredient.m_204132_((TagKey)TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)tag)));
    }
}

