/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.world.feature;

import java.util.List;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstapContext;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.OreConfiguration;
import net.minecraft.world.level.levelgen.structure.templatesystem.BlockMatchTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.RuleTest;
import net.minecraft.world.level.levelgen.structure.templatesystem.TagMatchTest;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.registry.BlockRegistry;

public class ConfiguredFeatures {
    public static final ResourceKey<ConfiguredFeature<?, ?>> MOONSTONE_ORE_KEY = ConfiguredFeatures.registerKey("moonstone_ore");
    public static final ResourceKey<ConfiguredFeature<?, ?>> VERGLAS_ORE_KEY = ConfiguredFeatures.registerKey("verglas_ore");

    public static void bootstrap(BootstapContext<ConfiguredFeature<?, ?>> context) {
        TagMatchTest stoneReplaceables = new TagMatchTest(BlockTags.f_144266_);
        TagMatchTest deepslateReplaceables = new TagMatchTest(BlockTags.f_144267_);
        TagMatchTest netherReplaceables = new TagMatchTest(BlockTags.f_13062_);
        BlockMatchTest endReplaceables = new BlockMatchTest(Blocks.f_50259_);
        List<OreConfiguration.TargetBlockState> overworldMoonstoneOres = List.of(OreConfiguration.m_161021_((RuleTest)stoneReplaceables, (BlockState)((Block)BlockRegistry.MOONSTONE_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateReplaceables, (BlockState)((Block)BlockRegistry.MOONSTONE_ORE_DEEPSLATE.get()).m_49966_()));
        List<OreConfiguration.TargetBlockState> overworldVerglasOres = List.of(OreConfiguration.m_161021_((RuleTest)stoneReplaceables, (BlockState)((Block)BlockRegistry.VERGLAS_ORE.get()).m_49966_()), OreConfiguration.m_161021_((RuleTest)deepslateReplaceables, (BlockState)((Block)BlockRegistry.VERGLAS_ORE_DEEPSLATE.get()).m_49966_()));
        ConfiguredFeatures.register(context, MOONSTONE_ORE_KEY, Feature.f_65731_, new OreConfiguration(overworldMoonstoneOres, ConfigConstructor.moonstone_ore_vein_size));
        ConfiguredFeatures.register(context, VERGLAS_ORE_KEY, Feature.f_65731_, new OreConfiguration(overworldVerglasOres, ConfigConstructor.verglas_ore_vein_size));
    }

    public static ResourceKey<ConfiguredFeature<?, ?>> registerKey(String name) {
        return ResourceKey.m_135785_((ResourceKey)Registries.f_256911_, (ResourceLocation)new ResourceLocation("soulsweapons", name));
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> void register(BootstapContext<ConfiguredFeature<?, ?>> context, ResourceKey<ConfiguredFeature<?, ?>> key, F feature, FC configuration) {
        context.m_255272_(key, (Object)new ConfiguredFeature(feature, configuration));
    }
}

