/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraftforge.fml.loading.FMLLoader;
import net.soulsweaponry.client.registry.KeyBindRegistry;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.BluemoonGreatsword;
import net.soulsweaponry.items.DarkinScythePre;
import net.soulsweaponry.items.IChargeNeeded;
import net.soulsweaponry.items.ShadowAssassinScythe;
import net.soulsweaponry.items.Skofnung;
import net.soulsweaponry.items.TrickWeapon;
import net.soulsweaponry.registry.WeaponRegistry;

public class WeaponUtil {
    public static final Enchantment[] DAMAGE_ENCHANTS = new Enchantment[]{Enchantments.f_44977_, Enchantments.f_44978_, Enchantments.f_44979_};
    public static final String PREV_TRICK_WEAPON = "trick_weapon_to_transform";
    public static final Set<Item> CUSTOM_HOLD_WEAPONS = Set.of((Item)WeaponRegistry.GUTS_SWORD.get(), (Item)WeaponRegistry.KRAKEN_SLAYER_CROSSBOW.get());
    public static final TrickWeapon[] TRICK_WEAPONS = new TrickWeapon[]{(TrickWeapon)WeaponRegistry.KIRKHAMMER.get(), (TrickWeapon)WeaponRegistry.SILVER_SWORD.get(), (TrickWeapon)WeaponRegistry.HOLY_GREATSWORD.get(), (TrickWeapon)WeaponRegistry.HOLY_MOONLIGHT_GREATSWORD.get(), (TrickWeapon)WeaponRegistry.HOLY_MOONLIGHT_SWORD.get()};

    public static boolean isModLoaded(String modId) {
        return FMLLoader.getLoadingModList().getModFileById(modId) != null;
    }

    public static int getEnchantDamageBonus(ItemStack stack) {
        for (Enchantment ench : DAMAGE_ENCHANTS) {
            if (EnchantmentHelper.m_44843_((Enchantment)ench, (ItemStack)stack) <= 0) continue;
            return EnchantmentHelper.m_44843_((Enchantment)ench, (ItemStack)stack);
        }
        return 0;
    }

    public static Component getSwitchWeaponName(ItemStack stack, TrickWeapon weapon) {
        TrickWeapon switchWeapon = TRICK_WEAPONS[weapon.getSwitchWeaponIndex()];
        if (stack.m_41782_() && stack.m_41783_().m_128441_(PREV_TRICK_WEAPON)) {
            switchWeapon = TRICK_WEAPONS[stack.m_41783_().m_128451_(PREV_TRICK_WEAPON)];
        }
        return switchWeapon.m_41466_();
    }

    public static List<Integer> arrayToList(int[] array) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int t : array) {
            list.add(t);
        }
        return list;
    }

    public static void addTooltip(List<Component> tooltip, String id, ChatFormatting formatting, int lines) {
        tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons." + id)).m_130940_(formatting));
        for (int i = 1; i <= lines; ++i) {
            tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons." + id + "_description_" + i)).m_130940_(ChatFormatting.GRAY));
        }
    }

    public static void addAbilityTooltip(TooltipAbilities ability, ItemStack stack, List<Component> tooltip) {
        switch (ability.ordinal()) {
            case 0: {
                Item item = stack.m_41720_();
                if (!(item instanceof TrickWeapon)) break;
                TrickWeapon weapon = (TrickWeapon)item;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.trick_weapon").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.trick_weapon_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.trick_weapon_description_2").m_130940_(ChatFormatting.DARK_GRAY).m_7220_(KeyBindRegistry.switchWeapon.m_90863_()));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.trick_weapon_description_3").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)WeaponUtil.getSwitchWeaponName(stack, weapon).m_6881_().m_130940_(ChatFormatting.WHITE)));
                break;
            }
            case 1: {
                IChargeNeeded item = (IChargeNeeded)stack.m_41720_();
                String current = Mth.m_14143_((float)((float)item.getCharge(stack) / (float)item.getMaxCharge() * 100.0f)) + "%";
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.charge").m_130940_(ChatFormatting.DARK_AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.charge_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.charge_description_2").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)(current + " | " + item.getAddedCharge(stack))).m_130940_(ChatFormatting.AQUA)));
                break;
            }
            case 2: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.charge_bonus_damage").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.charge_bonus_damage_1").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 3: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.need_charge").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.need_charge_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.need_charge_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 4: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lunar_herald_no_charge_1").m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lunar_herald_no_charge_2").m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            case 5: {
                int amount = Mth.m_14143_((float)((float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)stack) + ConfigConstructor.righteous_undead_bonus_damage));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.righteous").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.righteous_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.righteous_description_2").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(amount))));
                break;
            }
            case 6: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonfall").m_130944_(new ChatFormatting[]{ChatFormatting.AQUA, ChatFormatting.BOLD}));
                for (int i = 1; i <= 3; ++i) {
                    tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.moonfall_description_" + i)).m_130940_(ChatFormatting.GRAY));
                }
                break;
            }
            case 7: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.heavy_weapon").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.heavy_weapon_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.heavy_weapon_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.heavy_weapon_description_3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.heavy_weapon_description_4", (Object[])new Object[]{String.format("%.1f", Float.valueOf(ConfigConstructor.ultra_heavy_posture_loss_modifier_when_stagger_enchant))}).m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.heavy_weapon_description_5").m_130940_(ChatFormatting.GRAY));
                if (!ConfigConstructor.ultra_heavy_disables_shields) break;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.heavy_weapon_description_6").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 8: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.life_steal").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.life_steal_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 9: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.omnivamp").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.omnivamp_description").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.life_steal_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 10: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.overheal").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.overheal_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 11: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sword_slam").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sword_slam_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 12: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.grand_skyfall").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.grand_skyfall_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.grand_skyfall_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.grand_skyfall_description_3").m_130940_(ChatFormatting.GRAY));
                if (!WeaponUtil.isModLoaded("epicfight")) break;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.epic_fight.crouch_replaces_offhand").m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            case 13: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.infinity").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.infinity_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 14: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.crit").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.crit_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.crit_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 15: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.doom").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.doom_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.doom_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 16: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.blazing_blade").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.blazing_blade_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.blazing_blade_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 17: {
                if (!stack.m_150930_((Item)WeaponRegistry.DARKIN_SCYTHE_PRE.get())) break;
                DarkinScythePre scythe = (DarkinScythePre)stack.m_41720_();
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.transformation").m_130940_(ChatFormatting.LIGHT_PURPLE));
                for (int i = 1; i <= 7; ++i) {
                    tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.transformation_description_" + i)).m_130940_(ChatFormatting.GRAY));
                }
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.transformation_description_8").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(Mth.m_14143_((float)((float)scythe.getSouls(stack) / (float)scythe.MAX_SOULS * 100.0f)) + "%")).m_130940_(scythe.getDominantType(stack).equals((Object)DarkinScythePre.SoulType.BLUE) ? ChatFormatting.AQUA : ChatFormatting.RED)));
                break;
            }
            case 18: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.umbral_trespass").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.umbral_trespass_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.umbral_trespass_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.umbral_trespass_description_3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.umbral_trespass_description_4").m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.umbral_trespass_description_5").m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.umbral_trespass_description_6").m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            case 19: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.meridias_retribution").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.meridias_retribution_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.meridias_retribution_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 20: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.rage").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.rage_description").m_130940_(ChatFormatting.GRAY));
                WeaponUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                break;
            }
            case 21: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lightning").m_130940_(ChatFormatting.YELLOW));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lightning_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lightning_description_2").m_130940_(ChatFormatting.GRAY));
                if (!WeaponUtil.isModLoaded("epicfight")) break;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.epic_fight.crouch_replaces_offhand").m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            case 22: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.storm_stomp").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.storm_stomp_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 23: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.weatherborn").m_130940_(ChatFormatting.DARK_AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.weatherborn_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 24: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.dragon_staff").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.dragon_staff_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.dragon_staff_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 25: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.vengeful_fog").m_130940_(ChatFormatting.LIGHT_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.vengeful_fog_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.vengeful_fog_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.vengeful_fog_description_3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 26: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.night_prowler").m_130940_(ChatFormatting.DARK_AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.night_prowler_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 27: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.detonate_spears").m_130940_(ChatFormatting.RED));
                for (int i = 1; i <= 5; ++i) {
                    if (i == 3) {
                        tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.detonate_spears_description_" + i)).m_7220_((Component)Component.m_237113_((String)String.valueOf(ConfigConstructor.draupnir_spear_detonate_power + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44977_, (ItemStack)stack) / 2.5f)).m_130940_(ChatFormatting.WHITE)).m_130940_(ChatFormatting.GRAY));
                        continue;
                    }
                    tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.detonate_spears_description_" + i)).m_130940_(ChatFormatting.GRAY));
                }
                WeaponUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.detonate_spears_description_6").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.detonate_spears_description_7").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 28: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.featherlight").m_130940_(ChatFormatting.LIGHT_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.featherlight_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.featherlight_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 29: {
                String kills = "0";
                if (stack.m_41782_() && stack.m_41783_().m_128441_("kills")) {
                    kills = String.valueOf(stack.m_41783_().m_128451_("kills"));
                }
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_trap").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_trap_description").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_trap_kills").m_130940_(ChatFormatting.DARK_AQUA).m_7220_((Component)Component.m_237113_((String)kills).m_130940_(ChatFormatting.WHITE)));
                break;
            }
            case 30: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_release").m_130940_(ChatFormatting.DARK_BLUE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_release_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_release_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 31: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_release_wither").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_release_wither_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_release_wither_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.soul_release_wither_description_3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 32: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.collect_1").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.collect_2").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.collect_3").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case 33: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword_description_3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword_description_4").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword_description_5").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword_note_1").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword_note_2").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword_note_3").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword_note_4").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freyr_sword_note_5").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}));
                break;
            }
            case 34: {
                WeaponUtil.addTooltip(tooltip, "galeforce", ChatFormatting.AQUA, 6);
                WeaponUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                break;
            }
            case 35: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.fury").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.fury_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 36: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.haste").m_130940_(ChatFormatting.YELLOW));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.haste_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 37: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.flame_enraged").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.flame_enraged_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 38: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.returning").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.returning_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.returning_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.returning_description_3").m_7220_(KeyBindRegistry.returnThrownWeapon.m_90863_()).m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            case 39: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.heavy_throw").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.heavy_throw_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 40: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.permafrost").m_130940_(ChatFormatting.DARK_AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.permafrost_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.permafrost_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 41: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freeze").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.freeze_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 42: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.magic_damage").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.magic_damage_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.magic_damage_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.magic_damage_description_3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.magic_damage_description_4").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(ConfigConstructor.lich_bane_bonus_magic_damage + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44981_, (ItemStack)stack))).m_130940_(ChatFormatting.DARK_AQUA)));
                break;
            }
            case 43: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lightning").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.mjolnir_lightning_call_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.mjolnir_lightning_call_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.mjolnir_lightning_call_description_3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 44: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.off_hand_flight").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.off_hand_flight_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 45: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.mjolnir_throw").m_130944_(new ChatFormatting[]{ChatFormatting.LIGHT_PURPLE, ChatFormatting.BOLD}));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.mjolnir_throw_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.mjolnir_throw_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 46: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight_description").m_130940_(ChatFormatting.GRAY));
                if (!(stack.m_41720_() instanceof BluemoonGreatsword)) break;
                WeaponUtil.addAbilityTooltip(TooltipAbilities.LUNAR_HERALD_NO_CHARGE, stack, tooltip);
                break;
            }
            case 47: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight_attack_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight_attack_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight_attack_description_3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 48: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lunar_herald").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lunar_herald_description_1").m_130940_(ChatFormatting.GRAY).m_7220_(KeyBindRegistry.effectShootMoonlight.m_90863_()));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lunar_herald_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 49: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.ghost_summoner").m_130940_(ChatFormatting.DARK_AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.ghost_summoner_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 50: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.shield").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.shield_description").m_130940_(ChatFormatting.GRAY));
                WeaponUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                break;
            }
            case 51: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.obliterate").m_130940_(ChatFormatting.DARK_BLUE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.obliterate_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 52: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.pure_moonlight_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 53: {
                String seconds = String.valueOf(Mth.m_14143_((float)((float)ShadowAssassinScythe.TICKS_FOR_BONUS / 20.0f)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.early_combat").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.early_combat_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.early_combat_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.early_combat_description_3").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_GRAY, ChatFormatting.ITALIC}).m_7220_((Component)Component.m_237113_((String)seconds).m_130940_(ChatFormatting.AQUA)));
                break;
            }
            case 54: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.disable_heal").m_130940_(ChatFormatting.BOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.disable_heal_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.disable_heal_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 55: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sharpen").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sharpen_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sharpen_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sharpen_description_3").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 56: {
                if (!Skofnung.isEmpowered(stack)) break;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.empowered").m_130940_(ChatFormatting.AQUA).m_7220_((Component)Component.m_237113_((String)(Skofnung.empAttacksLeft(stack) + "/8")).m_130940_(ChatFormatting.AQUA)));
                break;
            }
            case 57: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.skofnung_stone").m_130940_(ChatFormatting.LIGHT_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.skofnung_stone_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.skofnung_stone_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 58: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.luminate").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.luminate_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 59: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.bane_of_arthropods").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.bane_of_arthropods_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.bane_of_arthropods_description_2").m_130940_(ChatFormatting.DARK_GRAY).m_7220_((Component)Component.m_237113_((String)String.valueOf(ConfigConstructor.sting_bonus_arthropod_damage)).m_130940_(ChatFormatting.AQUA)));
                break;
            }
            case 60: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sawblade").m_130940_(ChatFormatting.DARK_RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sawblade_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.sawblade_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 61: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.wabbajack").m_130944_(new ChatFormatting[]{ChatFormatting.DARK_RED, ChatFormatting.OBFUSCATED}));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.wabbajack_description").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 62: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lucky").m_130940_(ChatFormatting.DARK_GREEN));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lucky_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.lucky_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 63: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.parry").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.parry_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.parry_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.parry_description_3").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.parry_description_4").m_130940_(ChatFormatting.DARK_GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.parry_description_5").m_130940_(ChatFormatting.DARK_GRAY));
                break;
            }
            case 64: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.skyward_strikes").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.skyward_strikes_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.skyward_strikes_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 65: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.keybind_ability").m_130940_(ChatFormatting.DARK_GRAY).m_7220_(KeyBindRegistry.keybindAbility.m_90863_()));
                break;
            }
            case 66: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.nights_edge").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.nights_edge_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.nights_edge_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.nights_edge_description_3").m_130940_(ChatFormatting.GRAY));
                WeaponUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                break;
            }
            case 67: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_storm").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_storm_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.chaos_storm_description_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 68: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.veil_of_fire").m_130940_(ChatFormatting.GOLD).m_130940_(ChatFormatting.BOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.veil_of_fire_description_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.veil_of_fire_description_2").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.veil_of_fire_description_3").m_130940_(ChatFormatting.GRAY));
                WeaponUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
                break;
            }
            case 69: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.blight").m_130940_(ChatFormatting.LIGHT_PURPLE).m_130940_(ChatFormatting.BOLD));
                for (int i = 1; i <= 5; ++i) {
                    tooltip.add((Component)Component.m_237115_((String)("tooltip.soulsweapons.blight_description_" + i)).m_130940_(ChatFormatting.GRAY));
                }
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.blight_description_6").m_130940_(ChatFormatting.DARK_GRAY).m_130940_(ChatFormatting.ITALIC));
                break;
            }
            case 70: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.fast_pull").m_130940_(ChatFormatting.WHITE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.fast_pull_1").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 72: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.slow_pull").m_130940_(ChatFormatting.RED));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.slow_pull_1").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 71: {
                float bonus = 0.0f;
                if (stack.m_150930_((Item)WeaponRegistry.KRAKEN_SLAYER.get())) {
                    bonus = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)stack);
                }
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.third_shot").m_130940_(ChatFormatting.GOLD));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.third_shot_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237113_((String)String.valueOf(ConfigConstructor.kraken_slayer_bonus_true_damage + bonus)).m_130940_(ChatFormatting.WHITE).m_7220_((Component)Component.m_237115_((String)"tooltip.soulsweapons.third_shot_2").m_130940_(ChatFormatting.GRAY)));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.third_shot_3").m_130940_(ChatFormatting.GRAY).m_7220_((Component)Component.m_237113_((String)(Mth.m_14143_((float)((1.0f - ConfigConstructor.kraken_slayer_player_true_damage_taken_modifier) * 100.0f)) + "%"))).m_130940_(ChatFormatting.DARK_GRAY));
                if (!stack.m_150930_((Item)WeaponRegistry.KRAKEN_SLAYER_CROSSBOW.get())) break;
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.third_shot_4").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 73: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight_arrow").m_130940_(ChatFormatting.AQUA));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight_arrow_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.moonlight_arrow_2").m_130940_(ChatFormatting.GRAY));
                break;
            }
            case 74: {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arrow_storm").m_130940_(ChatFormatting.DARK_PURPLE));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arrow_storm_1").m_130940_(ChatFormatting.GRAY));
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.arrow_storm_2").m_130940_(ChatFormatting.GRAY));
                WeaponUtil.addAbilityTooltip(TooltipAbilities.KEYBIND_ABILITY, stack, tooltip);
            }
        }
    }

    public static enum TooltipAbilities {
        TRICK_WEAPON,
        CHARGE,
        CHARGE_BONUS_DAMAGE,
        NEED_CHARGE,
        LUNAR_HERALD_NO_CHARGE,
        RIGHTEOUS,
        MOONFALL,
        HEAVY,
        LIFE_STEAL,
        OMNIVAMP,
        OVERHEAL,
        SWORD_SLAM,
        SKYFALL,
        INFINITY,
        CRIT,
        DOOM,
        BLAZING_BLADE,
        TRANSFORMATION,
        UMBRAL_TRESPASS,
        DAWNBREAKER,
        RAGE,
        LIGHTNING_CALL,
        STORM_STOMP,
        WEATHERBORN,
        DRAGON_STAFF,
        VENGEFUL_FOG,
        NIGHT_PROWLER,
        DETONATE_SPEARS,
        FEATHERLIGHT,
        SOUL_TRAP,
        SOUL_RELEASE,
        SOUL_RELEASE_WITHER,
        COLLECT,
        SUMMON_WEAPON,
        GALEFORCE,
        FURY,
        HASTE,
        FLAME_ENRAGED,
        RETURNING,
        HEAVY_THROW,
        PERMAFROST,
        FREEZE,
        MAGIC_DAMAGE,
        MJOLNIR_LIGHTNING,
        OFF_HAND_FLIGHT,
        THROW_LIGHTNING,
        MOONLIGHT,
        MOONLIGHT_ATTACK,
        LUNAR_HERALD,
        SUMMON_GHOST,
        SHIELD,
        OBLITERATE,
        TRIPLE_MOONLIGHT,
        SHADOW_STEP,
        DISABLE_HEAL,
        SHARPEN,
        IS_SHARPENED,
        DISABLE_DEBUFS,
        LUMINATE,
        SPIDERS_BANE,
        SAWBLADE,
        WABBAJACK,
        LUCK_BASED,
        PARRY,
        SKYWARD_STRIKES,
        KEYBIND_ABILITY,
        NIGHTS_EDGE,
        CHAOS_STORM,
        VEIL_OF_FIRE,
        BLIGHT,
        FAST_PULL,
        THIRD_SHOT,
        SLOW_PULL,
        MOONLIGHT_ARROW,
        ARROW_STORM;

    }
}

