/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.util;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.particles.ParticleHandler;
import org.joml.Matrix4f;

public class CustomDeathHandler {
    private static final float HALF_SQRT_3 = (float)(Math.sqrt(3.0) / 2.0);

    public static void deathExplosionEvent(Level world, Vec3 pos, SoundEvent sound, ParticleOptions ... particles) {
        if (!world.f_46443_) {
            ParticleHandler.particleSphereList(world, 1000, pos.m_7096_(), pos.m_7098_(), pos.m_7094_(), 1.0f, particles);
        }
        world.m_5594_(null, BlockPos.m_274446_((Position)pos), sound, SoundSource.HOSTILE, 1.0f, 1.0f);
    }

    public static void renderDeathLight(LivingEntity entity, float entityYaw, float partialTicks, PoseStack stack, double[] translation, MultiBufferSource bufferIn, int packedLightIn, int deathTicks, int[] rgbColorOne, int[] rgbColorTwo, int[] rgbColorThree, int[] rgbColorFour) {
        if (deathTicks > 0) {
            float l = ((float)deathTicks + partialTicks) / 200.0f;
            float m = Math.min(l > 0.8f ? (l - 0.8f) / 0.2f : 0.0f, 1.0f);
            RandomSource random = RandomSource.m_216335_((long)432L);
            VertexConsumer vertexConsumer4 = bufferIn.m_6299_(RenderType.m_110502_());
            stack.m_85836_();
            stack.m_85837_(translation[0], translation[1], translation[2]);
            int n = 0;
            while ((float)n < (l + l * l) / 2.0f * 60.0f) {
                stack.m_252781_(Axis.f_252529_.m_252977_(random.m_188501_() * 360.0f));
                stack.m_252781_(Axis.f_252436_.m_252977_(random.m_188501_() * 360.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(random.m_188501_() * 360.0f));
                stack.m_252781_(Axis.f_252529_.m_252977_(random.m_188501_() * 360.0f));
                stack.m_252781_(Axis.f_252436_.m_252977_(random.m_188501_() * 360.0f));
                stack.m_252781_(Axis.f_252403_.m_252977_(random.m_188501_() * 360.0f + l * 90.0f));
                float o = random.m_188501_() * 20.0f + 5.0f + m * 10.0f;
                float p = random.m_188501_() * 2.0f + 1.0f + m * 2.0f;
                Matrix4f matrix4f = stack.m_85850_().m_252922_();
                int q = (int)(255.0f * (1.0f - m));
                CustomDeathHandler.renderLight_1(vertexConsumer4, matrix4f, q, rgbColorOne);
                CustomDeathHandler.renderLight_2(vertexConsumer4, matrix4f, o, p, rgbColorTwo);
                CustomDeathHandler.renderLight_3(vertexConsumer4, matrix4f, o, p, rgbColorThree);
                CustomDeathHandler.renderLight_1(vertexConsumer4, matrix4f, q, rgbColorOne);
                CustomDeathHandler.renderLight_3(vertexConsumer4, matrix4f, o, p, rgbColorThree);
                CustomDeathHandler.renderLight_4(vertexConsumer4, matrix4f, o, p, rgbColorFour);
                CustomDeathHandler.renderLight_1(vertexConsumer4, matrix4f, q, rgbColorOne);
                CustomDeathHandler.renderLight_4(vertexConsumer4, matrix4f, o, p, rgbColorFour);
                CustomDeathHandler.renderLight_2(vertexConsumer4, matrix4f, o, p, rgbColorTwo);
                ++n;
            }
            stack.m_85849_();
        }
    }

    private static void renderLight_1(VertexConsumer vertices, Matrix4f matrix, int alpha, int[] rgbColors) {
        vertices.m_252986_(matrix, 0.0f, 0.0f, 0.0f).m_6122_(rgbColors[0], rgbColors[1], rgbColors[2], alpha).m_5752_();
    }

    private static void renderLight_2(VertexConsumer vertices, Matrix4f matrix, float y, float x, int[] rgbColors) {
        vertices.m_252986_(matrix, -HALF_SQRT_3 * x, y, -0.5f * x).m_6122_(rgbColors[0], rgbColors[1], rgbColors[2], 0).m_5752_();
    }

    private static void renderLight_3(VertexConsumer vertices, Matrix4f matrix, float y, float x, int[] rgbColors) {
        vertices.m_252986_(matrix, HALF_SQRT_3 * x, y, -0.5f * x).m_6122_(rgbColors[0], rgbColors[1], rgbColors[2], 0).m_5752_();
    }

    private static void renderLight_4(VertexConsumer vertices, Matrix4f matrix, float y, float z, int[] rgbColors) {
        vertices.m_252986_(matrix, 0.0f, y, 1.0f * z).m_6122_(rgbColors[0], rgbColors[1], rgbColors[2], 0).m_5752_();
    }
}

