/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.networking.packets.C2S;

import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraftforge.network.NetworkEvent;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.items.DarkinScythePre;
import net.soulsweaponry.items.SoulHarvestingItem;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;

public class CollectSummonsC2S {
    public CollectSummonsC2S() {
    }

    public CollectSummonsC2S(FriendlyByteBuf buf) {
    }

    public void toBytes(FriendlyByteBuf buf) {
    }

    public void handle(Supplier<NetworkEvent.Context> supplier) {
        NetworkEvent.Context context = supplier.get();
        context.enqueueWork(() -> {
            ServerPlayer player = context.getSender();
            this.handlePacket(player, this);
        });
        context.setPacketHandled(true);
    }

    private void handlePacket(ServerPlayer player, CollectSummonsC2S packet) {
        for (InteractionHand hand : InteractionHand.values()) {
            Item handItem = player.m_21120_(hand).m_41720_();
            if (!(handItem instanceof SoulHarvestingItem) || handItem instanceof DarkinScythePre) continue;
            int collectedSouls = 0;
            for (Entity entity : player.m_9236_().m_45933_((Entity)player, player.m_20191_().m_82400_(8.0))) {
                Remnant remnant;
                if (!(entity instanceof Remnant) || (remnant = (Remnant)entity).m_269323_() == null || !remnant.m_269323_().equals((Object)player)) continue;
                collectedSouls += remnant.getSoulAmount();
                ParticleHandler.particleSphereList(player.m_9236_(), 10, entity.m_20185_(), entity.m_20186_(), entity.m_20189_(), ParticleEvents.DARK_EXPLOSION_LIST, 0.3f);
                player.m_9236_().m_5594_(null, entity.m_20183_(), SoundEvents.f_12644_, SoundSource.PLAYERS, 0.5f, 0.7f);
                entity.m_146870_();
            }
            SoulHarvestingItem item = (SoulHarvestingItem)player.m_21120_(hand).m_41720_();
            MutableComponent msg = null;
            if (ConfigConstructor.inform_player_about_no_souls_to_collect && collectedSouls == 0) {
                msg = Component.m_264568_((String)"soulsweapons.weapon.no_collected_souls", (String)"There were no bound allies to collect!");
            } else if (ConfigConstructor.inform_player_about_collected_souls && collectedSouls > 0) {
                msg = Component.m_237110_((String)"soulsweapons.weapon.collected_souls", (Object[])new Object[]{collectedSouls}).m_7220_(item.m_41466_());
            }
            item.addAmount(player.m_21120_(hand), collectedSouls);
            if (msg == null) continue;
            player.m_5661_((Component)msg, true);
        }
    }
}

