/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.mixin;

import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.player.AbstractClientPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fml.loading.FMLLoader;
import net.soulsweaponry.client.entitydata.ClientParryData;
import net.soulsweaponry.client.model.entity.mobs.ScythePosing;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.entitydata.ParryData;
import net.soulsweaponry.registry.WeaponRegistry;
import net.soulsweaponry.util.WeaponUtil;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={HumanoidModel.class})
public class BipedEntityModelMixin<T extends LivingEntity> {
    @Unique
    private float parryProgress;

    @Inject(at={@At(value="TAIL")}, method={"positionRightArm"})
    private void positionRightArm(T entity, CallbackInfo info) {
        HumanoidModel model = (HumanoidModel)this;
        for (ItemStack stack : entity.m_6167_()) {
            if (!WeaponUtil.CUSTOM_HOLD_WEAPONS.contains(stack.m_41720_())) continue;
            if (FMLLoader.getLoadingModList().getModFileById("bettercombat") == null) {
                if (stack.m_150930_((Item)WeaponRegistry.GUTS_SWORD.get())) {
                    AnimationUtils.m_102097_((ModelPart)model.f_102811_, (ModelPart)model.f_102812_, (ModelPart)model.f_102808_, (boolean)true);
                } else if (!stack.m_150930_((Item)WeaponRegistry.KRAKEN_SLAYER_CROSSBOW.get())) {
                    ScythePosing.hold(model.f_102811_, model.f_102812_, model.f_102808_, true);
                }
            } else if (entity instanceof Remnant) {
                AnimationUtils.m_102097_((ModelPart)model.f_102811_, (ModelPart)model.f_102812_, (ModelPart)model.f_102808_, (boolean)true);
            }
            if (!stack.m_150930_((Item)WeaponRegistry.KRAKEN_SLAYER_CROSSBOW.get())) continue;
            AnimationUtils.m_102097_((ModelPart)model.f_102811_, (ModelPart)model.f_102812_, (ModelPart)model.f_102808_, (boolean)true);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"animateArms"}, cancellable=true)
    protected void animateArms(T entity, float animationProgress, CallbackInfo info) {
        int frames;
        HumanoidModel model = (HumanoidModel)this;
        if (entity instanceof AbstractClientPlayer && (frames = ClientParryData.getParryFrames()) >= 1) {
            this.parryProgress = frames == 1 ? 0.1f : this.parryProgress;
            float added = 1.0f / (float)ParryData.MAX_PARRY_FRAMES / 3.0f;
            this.parryProgress = Math.min(this.parryProgress + added, 1.0f);
            ModelPart modelPart = model.f_102812_;
            float f = this.parryProgress;
            model.f_102810_.f_104204_ = Mth.m_14031_((float)(Mth.m_14116_((float)f) * ((float)Math.PI * 2))) * 0.2f;
            model.f_102812_.f_104202_ = -Mth.m_14031_((float)model.f_102810_.f_104204_) * 5.0f;
            model.f_102812_.f_104200_ = Mth.m_14089_((float)model.f_102810_.f_104204_) * 5.0f;
            model.f_102812_.f_104204_ += model.f_102810_.f_104204_;
            model.f_102812_.f_104203_ += model.f_102810_.f_104204_;
            f = 1.0f - this.parryProgress;
            f *= f;
            f *= f;
            f = 1.0f - f;
            float g = Mth.m_14031_((float)(f * (float)Math.PI));
            float h = Mth.m_14031_((float)(this.parryProgress * (float)Math.PI)) * -(model.f_102808_.f_104203_ - 0.7f) * 0.75f;
            modelPart.f_104203_ -= g * 1.2f + h;
            modelPart.f_104204_ += model.f_102810_.f_104204_ * 2.0f;
            modelPart.f_104205_ += Mth.m_14031_((float)(this.parryProgress * (float)Math.PI)) * -0.4f;
        }
        if (FMLLoader.getLoadingModList().getModFileById("bettercombat") == null) {
            ItemStack stack = entity.m_21205_();
            if (model.f_102608_ > 0.0f && WeaponUtil.CUSTOM_HOLD_WEAPONS.contains(stack.m_41720_())) {
                ScythePosing.meleeAttack(model.f_102812_, model.f_102811_, entity, ((LivingEntity)entity).f_20921_, animationProgress);
                info.cancel();
            }
        }
    }
}

