/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.IUltraHeavy;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.util.WeaponUtil;

public class TrickWeapon
extends ModdedSword
implements IUltraHeavy {
    private static final int[] DAMAGE = new int[]{ConfigConstructor.kirkhammer_damage, ConfigConstructor.kirkhammer_silver_sword_damage, ConfigConstructor.ludwigs_holy_greatsword_damage, ConfigConstructor.holy_moonlight_greatsword_damage, ConfigConstructor.holy_moonlight_sword_damage};
    private static final float[] ATTACK_SPEED = new float[]{ConfigConstructor.kirkhammer_attack_speed, ConfigConstructor.kirkhammer_silver_sword_attack_speed, ConfigConstructor.ludwigs_holy_greatsword_attack_speed, ConfigConstructor.holy_moonlight_greatsword_attack_speed, ConfigConstructor.holy_moonlight_sword_attack_speed};
    private static final boolean[] DISABLE = new boolean[]{ConfigConstructor.disable_use_kirkhammer, ConfigConstructor.disable_use_silver_sword, ConfigConstructor.disable_use_ludwigs_holy_greatsword, ConfigConstructor.disable_use_holy_moonlight_greatsword, ConfigConstructor.disable_use_holy_moonlight_sword};
    private static final boolean[] FIREPROOF = new boolean[]{ConfigConstructor.is_fireproof_kirkhammer, ConfigConstructor.is_fireproof_silver_sword, ConfigConstructor.is_fireproof_ludwigs_holy_blade, ConfigConstructor.is_fireproof_holy_moonlight_greatsword, ConfigConstructor.is_fireproof_holy_moonlight_sword};
    private final int switchWeaponIndex;
    private final int ownWeaponIndex;
    private final boolean undeadBonus;
    private final boolean isHeavy;
    private final int arrayIndex;

    public TrickWeapon(Tier toolMaterial, int damageIndex, Item.Properties settings, int switchWeaponIndex, int ownWeaponIndex, boolean isHeavy, boolean undeadBonus) {
        super(toolMaterial, DAMAGE[damageIndex], ATTACK_SPEED[damageIndex], settings);
        this.switchWeaponIndex = switchWeaponIndex;
        this.ownWeaponIndex = ownWeaponIndex;
        this.undeadBonus = undeadBonus;
        this.isHeavy = isHeavy;
        this.arrayIndex = damageIndex;
        this.addTooltipAbility(WeaponUtil.TooltipAbilities.TRICK_WEAPON);
        if (this.isHeavy()) {
            this.addTooltipAbility(WeaponUtil.TooltipAbilities.HEAVY);
        }
        if (this.undeadBonus) {
            this.addTooltipAbility(WeaponUtil.TooltipAbilities.RIGHTEOUS);
        }
    }

    public int getSwitchWeaponIndex() {
        return this.switchWeaponIndex;
    }

    public int getOwnWeaponIndex() {
        return this.ownWeaponIndex;
    }

    public boolean hasUndeadBonus() {
        return this.undeadBonus;
    }

    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (this.isDisabled(stack)) {
            return super.m_7579_(stack, target, attacker);
        }
        if (this.isHeavy) {
            this.gainStrength(attacker);
        }
        return super.m_7579_(stack, target, attacker);
    }

    @Override
    public boolean isHeavy() {
        return this.isHeavy;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return DISABLE[this.arrayIndex];
    }

    @Override
    public boolean m_41475_() {
        return FIREPROOF[this.arrayIndex];
    }

    public int getChargeTime(ItemStack stack, int remainingUseTicks) {
        int i = WeaponUtil.isModLoaded("epicfight") ? Integer.MAX_VALUE - remainingUseTicks : this.m_8105_(stack) - remainingUseTicks;
        return i;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String getReduceCooldownEnchantId(ItemStack stack) {
        return null;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return ConfigConstructor.ultra_heavy_disables_shields && this.isHeavy;
    }
}

