/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.items.Skofnung;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.WeaponUtil;

public class SkofnungStone
extends Item
implements IConfigDisable {
    public SkofnungStone(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stoneStack = user.m_21120_(hand);
        if (this.isDisabled(stoneStack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)stoneStack);
        }
        boolean shouldDamage = false;
        for (InteractionHand offHand : InteractionHand.values()) {
            ItemStack swordStack = user.m_21120_(offHand);
            if (!(swordStack.m_41720_() instanceof Skofnung) || !swordStack.m_41782_()) continue;
            swordStack.m_41783_().m_128405_("empowered_attacks_left", ConfigConstructor.skofnung_stone_additional_empowered_strikes);
            shouldDamage = true;
            world.m_5594_(user, user.m_20183_(), (SoundEvent)SoundRegistry.SHARPEN_EVENT.get(), SoundSource.PLAYERS, 0.5f, 1.0f);
            world.m_5594_(user, user.m_20183_(), SoundEvents.f_11894_, SoundSource.PLAYERS, 0.5f, 0.5f);
        }
        for (MobEffect effect : BuiltInRegistries.f_256974_) {
            if (!effect.m_19483_().equals((Object)MobEffectCategory.HARMFUL) || !user.m_21023_(effect)) continue;
            user.m_21195_(effect);
            world.m_5594_(user, user.m_20183_(), (SoundEvent)SoundRegistry.RESTORE_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            shouldDamage = true;
        }
        if (shouldDamage) {
            stoneStack.m_41622_(1, (LivingEntity)user, e -> e.m_21190_(hand));
            return InteractionResultHolder.m_19090_((Object)user.m_21120_(hand));
        }
        return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
    }

    public void m_7373_(ItemStack stack, Level world, List<Component> tooltip, TooltipFlag context) {
        if (this.isDisabled(stack)) {
            tooltip.add((Component)Component.m_264568_((String)"tooltip.soulsweapons.disabled", (String)"Disabled"));
        }
        if (Screen.m_96638_()) {
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.DISABLE_DEBUFS, stack, tooltip);
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.shift"));
        }
        super.m_7373_(stack, world, tooltip, context);
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_skofnung_stone;
    }
}

