/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.soulsweaponry.client.renderer.item.NightfallRenderer;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.Remnant;
import net.soulsweaponry.entitydata.SummonsData;
import net.soulsweaponry.items.ISummonAllies;
import net.soulsweaponry.items.UltraHeavyWeapon;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import net.soulsweaponry.util.IKeybindAbility;
import net.soulsweaponry.util.WeaponUtil;
import software.bernie.geckolib.animatable.GeoItem;
import software.bernie.geckolib.core.animatable.GeoAnimatable;
import software.bernie.geckolib.core.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.core.animation.AnimatableManager;
import software.bernie.geckolib.util.GeckoLibUtil;

public class Nightfall
extends UltraHeavyWeapon
implements GeoItem,
IKeybindAbility,
ISummonAllies {
    private final AnimatableInstanceCache factory = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);

    public Nightfall(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, ConfigConstructor.nightfall_damage, ConfigConstructor.nightfall_attack_speed, settings, true);
        this.addTooltipAbility(WeaponUtil.TooltipAbilities.SUMMON_GHOST, WeaponUtil.TooltipAbilities.SHIELD, WeaponUtil.TooltipAbilities.OBLITERATE);
    }

    @Override
    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player player = (Player)user;
            int i = this.getChargeTime(stack, remainingUseTicks);
            if (i >= 10) {
                this.applyItemCooldown(player, this.getScaledCooldownSmash(stack));
                stack.m_41622_(3, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21190_(player.m_7655_()));
                Vec3 vecBlocksAway = player.m_20154_().m_82490_(3.0).m_82549_(player.m_20182_());
                BlockPos targetArea = new BlockPos((int)vecBlocksAway.f_82479_, (int)user.m_20186_(), (int)vecBlocksAway.f_82481_);
                AABB aoe = new AABB(targetArea).m_82400_(3.0);
                List entities = world.m_45933_((Entity)player, aoe);
                float power = ConfigConstructor.nightfall_ability_damage;
                for (Entity entity : entities) {
                    if (!(entity instanceof LivingEntity)) continue;
                    LivingEntity target = (LivingEntity)entity;
                    entity.m_6469_(CustomDamageSource.create(world, CustomDamageSource.OBLITERATED, (Entity)player), power + 2.0f * EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)((LivingEntity)entity).m_6336_()));
                    entity.m_20334_(entity.m_20184_().f_82479_, 0.5, entity.m_20184_().f_82481_);
                    this.spawnRemnant(target, user);
                }
                world.m_5594_(player, targetArea, (SoundEvent)SoundRegistry.NIGHTFALL_BONK_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!world.f_46443_) {
                    ParticleHandler.particleOutburstMap(world, 150, targetArea.m_123341_(), (float)targetArea.m_123342_() + 0.1f, targetArea.m_123343_(), ParticleEvents.OBLITERATE_MAP, 1.0f);
                }
            }
        }
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.nightfall_enchant_reduces_cooldown;
    }

    @Override
    public String getReduceCooldownEnchantId(ItemStack stack) {
        return ConfigConstructor.nightfall_enchant_reduces_cooldown_id;
    }

    protected int getScaledCooldownSmash(ItemStack stack) {
        int base = ConfigConstructor.nightfall_smash_cooldown;
        return Math.max(ConfigConstructor.nightfall_smash_min_cooldown, base - this.getReduceCooldownEnchantLevel(stack) * 50);
    }

    protected int getScaledCooldownShield(ItemStack stack) {
        int base = ConfigConstructor.nightfall_shield_cooldown;
        return Math.max(ConfigConstructor.nightfall_shield_min_cooldown, base - this.getReduceCooldownEnchantLevel(stack) * 100);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!this.isDisabled(stack)) {
            this.spawnRemnant(target, attacker);
        }
        return super.m_7579_(stack, target, attacker);
    }

    public void spawnRemnant(LivingEntity target, LivingEntity attacker) {
        if (target.m_21222_() && target.m_21224_() && attacker instanceof Player && !this.isDisabled(attacker.m_21205_())) {
            double chance = new Random().nextDouble();
            Level world = attacker.m_20193_();
            if (!world.f_46443_ && this.canSummonEntity((ServerLevel)world, attacker, this.getSummonsListId()) && chance < ConfigConstructor.nightfall_summon_chance) {
                Remnant entity = new Remnant((EntityType<? extends TamableAnimal>)((EntityType)EntityRegistry.REMNANT.get()), world);
                entity.m_20343_(target.m_20185_(), target.m_20186_() + (double)0.1f, target.m_20189_());
                entity.m_21828_((Player)attacker);
                world.m_7967_((Entity)entity);
                this.saveSummonUuid(attacker, entity.m_20148_());
                world.m_5594_(null, target.m_20183_(), (SoundEvent)SoundRegistry.NIGHTFALL_SPAWN_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!attacker.m_9236_().f_46443_) {
                    ParticleHandler.particleOutburstMap(attacker.m_9236_(), 50, target.m_20185_(), target.m_20186_(), target.m_20189_(), ParticleEvents.SOUL_RUPTURE_MAP, 1.0f);
                }
            }
        }
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.factory;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new IClientItemExtensions(){
            private NightfallRenderer renderer = null;

            public BlockEntityWithoutLevelRenderer getCustomRenderer() {
                if (this.renderer == null) {
                    this.renderer = new NightfallRenderer();
                }
                return this.renderer;
            }
        });
    }

    @Override
    public Component[] getAdditionalTooltips() {
        return new Component[]{Component.m_237115_((String)"tooltip.soulsweapons.nightfall.part_1").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.nightfall.part_2").m_130940_(ChatFormatting.DARK_GRAY), Component.m_237115_((String)"tooltip.soulsweapons.nightfall.part_3").m_130940_(ChatFormatting.DARK_GRAY)};
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_nightfall;
    }

    @Override
    public void useKeybindAbilityServer(ServerLevel world, ItemStack stack, Player player) {
        if (!player.m_36335_().m_41519_((Item)this)) {
            this.applyItemCooldown(player, this.getScaledCooldownShield(stack));
            stack.m_41622_(3, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21190_(player.m_7655_()));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19617_, 200, ConfigConstructor.nightfall_ability_shield_power));
            player.m_7292_(new MobEffectInstance(MobEffects.f_19606_, 200, 0));
            world.m_5594_(null, player.m_20183_(), (SoundEvent)SoundRegistry.NIGHTFALL_SHIELD_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        }
    }

    @Override
    public void useKeybindAbilityClient(ClientLevel world, ItemStack stack, LocalPlayer player) {
    }

    @Override
    public float getBaseExpansion() {
        return ConfigConstructor.nightfall_calculated_fall_base_radius;
    }

    @Override
    public float getExpansionModifier() {
        return ConfigConstructor.nightfall_calculated_fall_height_increase_radius_modifier;
    }

    @Override
    public float getLaunchModifier() {
        return ConfigConstructor.nightfall_calculated_fall_target_launch_modifier;
    }

    @Override
    public float getMaxLaunchPower() {
        return ConfigConstructor.nightfall_calculated_fall_target_max_launch_power;
    }

    @Override
    public float getMaxExpansion() {
        return ConfigConstructor.nightfall_calculated_fall_max_radius;
    }

    @Override
    public float getMaxDetonationDamage() {
        return ConfigConstructor.nightfall_calculated_fall_max_damage;
    }

    @Override
    public float getFallDamageIncreaseModifier() {
        return ConfigConstructor.nightfall_calculated_fall_height_increase_damage_modifier;
    }

    @Override
    public boolean shouldHeal() {
        return ConfigConstructor.nightfall_calculated_fall_should_heal;
    }

    @Override
    public float getHealFromDamageModifier() {
        return ConfigConstructor.nightfall_calculated_fall_heal_from_damage_modifier;
    }

    @Override
    public void doCustomEffects(LivingEntity target, LivingEntity user) {
        this.spawnRemnant(target, user);
    }

    @Override
    public Map<ParticleOptions, Vec3> getParticles() {
        HashMap<ParticleOptions, Vec3> map = new HashMap<ParticleOptions, Vec3>();
        map.put((ParticleOptions)ParticleTypes.f_123745_, new Vec3(1.0, 6.0, 1.0));
        return map;
    }

    @Override
    public int getMaxSummons() {
        return ConfigConstructor.nightfall_summoned_allies_cap;
    }

    @Override
    public String getSummonsListId() {
        return "NightfallSummons";
    }

    @Override
    public void saveSummonUuid(LivingEntity user, UUID summonUuid) {
        SummonsData.addSummonUUID(user, summonUuid, this.getSummonsListId());
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_nightfall;
    }
}

