/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.Nullable;

public class MoonstoneRing
extends Item
implements IConfigDisable {
    public MoonstoneRing(Item.Properties settings) {
        super(settings);
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        if (this.isDisabled(stack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)stack);
        }
        if (!user.m_21023_((MobEffect)EffectRegistry.MOON_HERALD.get())) {
            user.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.MOON_HERALD.get(), 600, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44986_, (ItemStack)stack)));
            stack.m_41622_(1, (LivingEntity)user, e -> e.m_21190_(hand));
            world.m_5594_(null, user.m_20183_(), SoundEvents.f_12616_, SoundSource.PLAYERS, 1.0f, 1.0f);
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        if (this.isDisabled(stack)) {
            tooltip.add((Component)Component.m_264568_((String)"tooltip.soulsweapons.disabled", (String)"Disabled"));
        }
        if (Screen.m_96638_()) {
            WeaponUtil.addAbilityTooltip(WeaponUtil.TooltipAbilities.LUNAR_HERALD, stack, tooltip);
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.shift"));
        }
        super.m_7373_(stack, world, tooltip, context);
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_moonstone_ring;
    }

    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_moonlight_ring;
    }
}

