/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.items.ICooldownItem;
import net.soulsweaponry.util.WeaponUtil;
import org.jetbrains.annotations.Nullable;

public abstract class ModdedSword
extends SwordItem
implements IConfigDisable,
ICooldownItem {
    protected final float attackSpeed;
    protected final List<WeaponUtil.TooltipAbilities> tooltipAbilities = new ArrayList<WeaponUtil.TooltipAbilities>();

    public ModdedSword(Tier toolMaterial, int attackDamage, float ingameAttackSpeed, Item.Properties settings) {
        super(toolMaterial, attackDamage, -(4.0f - ingameAttackSpeed), settings);
        this.attackSpeed = -(4.0f - ingameAttackSpeed);
    }

    public float getAttackSpeed() {
        return this.attackSpeed;
    }

    public List<WeaponUtil.TooltipAbilities> getTooltipAbilities() {
        return this.tooltipAbilities;
    }

    public void addTooltipAbility(WeaponUtil.TooltipAbilities ... abilities) {
        Collections.addAll(this.tooltipAbilities, abilities);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        boolean epicFight;
        boolean showInfo;
        if (this.isDisabled(stack)) {
            tooltip.add((Component)Component.m_264568_((String)"tooltip.soulsweapons.disabled", (String)"Disabled"));
        }
        boolean bl = showInfo = !(epicFight = WeaponUtil.isModLoaded("epicfight")) ? Screen.m_96638_() : Screen.m_96639_();
        if (showInfo) {
            for (WeaponUtil.TooltipAbilities ability : this.getTooltipAbilities()) {
                WeaponUtil.addAbilityTooltip(ability, stack, tooltip);
            }
            tooltip.addAll(Arrays.asList(this.getAdditionalTooltips()));
        } else if (epicFight) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.alt"));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.shift"));
        }
        super.m_7373_(stack, world, tooltip, context);
    }

    public Component[] getAdditionalTooltips() {
        return new Component[0];
    }

    public void notifyCooldown(LivingEntity user) {
        if (!ConfigConstructor.inform_player_about_cooldown_effect) {
            return;
        }
        if (user instanceof Player) {
            Player player = (Player)user;
            player.m_5661_((Component)Component.m_264568_((String)"soulsweapons.weapon.on_cooldown", (String)"Can't cast this ability with the Cooldown effect!"), true);
        } else {
            user.m_213846_((Component)Component.m_264568_((String)"soulsweapons.weapon.on_cooldown", (String)"Can't cast this ability with the Cooldown effect!"));
        }
    }

    public abstract boolean m_41475_();
}

