/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.util.WeaponUtil;

public interface ICooldownItem {
    default public void applyItemCooldown(Player player, int cooldown) {
        if (!player.m_7500_()) {
            player.m_36335_().m_41524_((Item)this, cooldown);
        }
    }

    default public void applyEffectCooldown(Player player, int cooldown) {
        if (!player.m_7500_()) {
            player.m_7292_(new MobEffectInstance((MobEffect)EffectRegistry.COOLDOWN.get(), cooldown, 0));
        }
    }

    default public int getReduceCooldownEnchantLevel(ItemStack stack) {
        if (this.canEnchantReduceCooldown(stack)) {
            String string = this.getReduceCooldownEnchantId(stack);
            if (string.equals("damage")) {
                return WeaponUtil.getEnchantDamageBonus(stack);
            }
            ResourceLocation id = new ResourceLocation(string);
            Enchantment enchantment = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(id);
            if (enchantment != null) {
                return EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)stack);
            }
        }
        return 0;
    }

    default public int getReduceLifeStealCooldownEnchantLevel(ItemStack stack) {
        if (ConfigConstructor.lifesteal_item_enchant_reduces_cooldown) {
            String string = ConfigConstructor.lifesteal_item_enchant_reduces_cooldown_id;
            if (string.equals("damage")) {
                return WeaponUtil.getEnchantDamageBonus(stack);
            }
            ResourceLocation id = new ResourceLocation(string);
            Enchantment enchantment = (Enchantment)BuiltInRegistries.f_256876_.m_7745_(id);
            if (enchantment != null) {
                return EnchantmentHelper.m_44843_((Enchantment)enchantment, (ItemStack)stack);
            }
        }
        return 0;
    }

    public boolean canEnchantReduceCooldown(ItemStack var1);

    public String getReduceCooldownEnchantId(ItemStack var1);
}

