/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.Cannonball;
import net.soulsweaponry.entity.projectile.SilverBulletEntity;
import net.soulsweaponry.items.GunItem;
import net.soulsweaponry.registry.EnchantRegistry;
import net.soulsweaponry.registry.ItemRegistry;

public class HunterCannon
extends GunItem {
    public HunterCannon(Item.Properties settings) {
        super(settings);
    }

    @Override
    public int getPostureLoss(ItemStack stack) {
        int lvl = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.VISCERAL, (ItemStack)stack);
        return ConfigConstructor.hunter_cannon_posture_loss * (lvl == 0 ? 1 : lvl);
    }

    @Override
    public float getBulletDamage(ItemStack stack) {
        return ConfigConstructor.hunter_cannon_damage;
    }

    @Override
    public float getBulletVelocity(ItemStack stack) {
        return ConfigConstructor.hunter_cannon_velocity;
    }

    @Override
    public float getBulletDivergence(ItemStack stack) {
        return ConfigConstructor.hunter_cannon_divergence;
    }

    @Override
    public int getCooldown(ItemStack stack) {
        return ConfigConstructor.hunter_cannon_cooldown - 4 * this.getReducedCooldown(stack) + EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) * 50;
    }

    @Override
    public int bulletsNeeded() {
        return ConfigConstructor.hunter_cannon_bullets_needed;
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_hunter_cannon;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack stack = user.m_21120_(hand);
        if (this.isDisabled(stack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
        }
        boolean bl = user.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
        ItemStack itemStack = user.m_6298_(stack);
        int bulletsNeeded = this.bulletsNeeded();
        if (!itemStack.m_41619_() && itemStack.m_41613_() >= bulletsNeeded || bl) {
            if (itemStack.m_41619_()) {
                itemStack = new ItemStack((ItemLike)ItemRegistry.SILVER_BULLET.get());
            }
            boolean bl2 = bl && itemStack.m_150930_((Item)ItemRegistry.SILVER_BULLET.get());
            Vec3 pov = user.m_20154_();
            Vec3 particleBox = pov.m_82490_(1.0).m_82549_(user.m_20182_());
            if (world.f_46443_) {
                for (int k = 0; k < 50; ++k) {
                    world.m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, particleBox.f_82479_, particleBox.f_82480_ + 1.5, particleBox.f_82481_, pov.f_82479_ + user.m_217043_().m_188500_() - 0.5, pov.f_82480_ + user.m_217043_().m_188500_() - 0.5, pov.f_82481_ + user.m_217043_().m_188500_() - 0.5);
                    world.m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, particleBox.f_82479_, particleBox.f_82480_ + 1.5, particleBox.f_82481_, pov.f_82479_ + user.m_217043_().m_188500_() - 0.5, pov.f_82480_ + user.m_217043_().m_188500_() - 0.5, pov.f_82481_ + user.m_217043_().m_188500_() - 0.5);
                }
            }
            AbstractArrow entity = this.createSilverBulletEntity(world, (LivingEntity)user, stack);
            world.m_7967_((Entity)entity);
            world.m_5594_(user, user.m_20183_(), SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
            stack.m_41622_(bulletsNeeded, (LivingEntity)user, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
            if (!bl2 && !user.m_150110_().f_35937_) {
                itemStack.m_41774_(bulletsNeeded);
                if (itemStack.m_41619_()) {
                    user.m_150109_().m_36057_(itemStack);
                }
            }
            float f = user.m_146908_();
            float g = user.m_146909_();
            float h = -Mth.m_14031_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(g * ((float)Math.PI / 180)));
            float k = -Mth.m_14031_((float)(g * ((float)Math.PI / 180)));
            float l = Mth.m_14089_((float)(f * ((float)Math.PI / 180))) * Mth.m_14089_((float)(g * ((float)Math.PI / 180)));
            float m = Mth.m_14116_((float)(h * h + k * k + l * l));
            float n = 1.0f;
            user.m_5997_(-((double)(h *= n / m)), -((double)(k *= n / m)), -((double)(l *= n / m)));
            user.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            if (!user.m_7500_()) {
                user.m_36335_().m_41524_((Item)this, this.getCooldown(stack));
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)world.m_5776_());
        }
        return InteractionResultHolder.m_19100_((Object)stack);
    }

    @Override
    public SilverBulletEntity getModdedProjectile(Level world, LivingEntity shooter, ItemStack gunStack) {
        return new Cannonball(world, shooter);
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_hunter_cannon;
    }
}

