/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.invisible.HolyMoonlightPillar;
import net.soulsweaponry.items.IChargeNeeded;
import net.soulsweaponry.items.TrickWeapon;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import net.soulsweaponry.registry.EffectRegistry;
import net.soulsweaponry.registry.EntityRegistry;
import net.soulsweaponry.registry.SoundRegistry;
import net.soulsweaponry.util.CustomDamageSource;
import net.soulsweaponry.util.WeaponUtil;

public class HolyMoonlightGreatsword
extends TrickWeapon
implements IChargeNeeded {
    public HolyMoonlightGreatsword(Tier toolMaterial, Item.Properties settings, int switchWeaponIndex) {
        super(toolMaterial, 3, settings, switchWeaponIndex, 3, false, true);
        this.addTooltipAbility(WeaponUtil.TooltipAbilities.NEED_CHARGE, WeaponUtil.TooltipAbilities.LUNAR_HERALD_NO_CHARGE, WeaponUtil.TooltipAbilities.CHARGE, WeaponUtil.TooltipAbilities.MOONFALL);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        if (user instanceof Player) {
            Player player = (Player)user;
            int chargeTime = this.getChargeTime(stack, remainingUseTicks);
            if (chargeTime >= 10) {
                int emp = player.m_21023_((MobEffect)EffectRegistry.MOON_HERALD.get()) ? 20 * player.m_21124_((MobEffect)EffectRegistry.MOON_HERALD.get()).m_19564_() : 0;
                this.applyItemCooldown(player, Math.max(ConfigConstructor.holy_moonlight_ability_min_cooldown, ConfigConstructor.holy_moonlight_ability_cooldown - this.getReduceCooldownEnchantLevel(stack) * 30 - emp));
                stack.m_41622_(5, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21190_(player.m_7655_()));
                int ruptures = ConfigConstructor.holy_moonlight_ruptures_amount + WeaponUtil.getEnchantDamageBonus(stack);
                Vec3 vecBlocksAway = player.m_20154_().m_82490_(3.0).m_82549_(player.m_20182_());
                BlockPos targetArea = new BlockPos((int)vecBlocksAway.f_82479_, (int)user.m_20186_(), (int)vecBlocksAway.f_82481_);
                float power = ConfigConstructor.holy_moonlight_ability_damage;
                for (Entity entity : world.m_45933_((Entity)player, new AABB(targetArea).m_82400_(3.0))) {
                    if (!(entity instanceof LivingEntity)) continue;
                    entity.m_6469_(CustomDamageSource.create(world, CustomDamageSource.OBLITERATED, (Entity)player), power + 2.0f * EnchantmentHelper.m_44833_((ItemStack)stack, (MobType)((LivingEntity)entity).m_6336_()));
                    entity.m_5997_(0.0, (double)this.getKnockup(stack), 0.0);
                }
                if (!world.f_46443_) {
                    this.castSpell((LivingEntity)player, world, stack, ruptures, this.getAbilityDamage(), this.getKnockup(stack), user.m_146908_() + 90.0f);
                }
                if (stack.m_41782_() && !player.m_7500_()) {
                    stack.m_41783_().m_128405_("current_charge", 0);
                }
                world.m_5594_(player, targetArea, (SoundEvent)SoundRegistry.MOONLIGHT_BIG_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                world.m_5594_(player, targetArea, SoundEvents.f_11913_, SoundSource.PLAYERS, 1.0f, 1.0f);
                if (!world.f_46443_) {
                    ParticleHandler.particleOutburstMap(player.m_9236_(), 150, vecBlocksAway.m_7096_(), user.m_20186_(), vecBlocksAway.m_7094_(), ParticleEvents.MOONFALL_MAP, 1.0f);
                }
            }
        }
    }

    public void castSpell(LivingEntity user, Level world, ItemStack stack, Vec3 startPos, int amount, float damage, float knockup, float yaw, float particleMod, float radius) {
        double maxY = startPos.m_7098_();
        double y = startPos.m_7098_() + 1.0;
        float f = (float)Math.toRadians(yaw);
        for (int i = 0; i < amount; ++i) {
            double h = 1.75 * (double)(i + 1);
            this.summonPillars(user, world, stack, startPos.m_7096_() + (double)Mth.m_14089_((float)f) * h, startPos.m_7094_() + (double)Mth.m_14031_((float)f) * h, maxY, y, -6 + i * 2, damage, knockup, particleMod, radius);
        }
    }

    private void summonPillars(LivingEntity user, Level world, ItemStack stack, double x, double z, double maxY, double y, int warmup, float damage, float knockup, float particleMod, float radius) {
        BlockPos blockPos = new BlockPos((int)x, (int)y, (int)z);
        boolean bl = false;
        double d = 0.0;
        do {
            VoxelShape voxelShape;
            BlockPos blockPos2;
            if (!world.m_8055_(blockPos2 = blockPos.m_7495_()).m_60783_((BlockGetter)world, blockPos2, Direction.UP)) continue;
            if (!world.m_46859_(blockPos) && !(voxelShape = world.m_8055_(blockPos).m_60812_((BlockGetter)world, blockPos)).m_83281_()) {
                d = voxelShape.m_83297_(Direction.Axis.Y);
            }
            bl = true;
            break;
        } while ((blockPos = blockPos.m_7495_()).m_123342_() >= Mth.m_14107_((double)maxY) - 1);
        if (bl) {
            HolyMoonlightPillar pillar = new HolyMoonlightPillar((EntityType<? extends AbstractArrow>)((EntityType)EntityRegistry.HOLY_MOONLIGHT_PILLAR.get()), world);
            pillar.m_5602_((Entity)user);
            pillar.setParticleMod(particleMod);
            pillar.setRadius(radius);
            pillar.m_36781_(damage);
            pillar.setKnockUp(knockup);
            pillar.setWarmup(warmup);
            pillar.m_20343_(x, (double)blockPos.m_123342_() + d, z);
            world.m_7967_((Entity)pillar);
        }
    }

    public void castSpell(LivingEntity user, Level world, ItemStack stack, int amount, float damage, float knockup, float yaw) {
        this.castSpell(user, world, stack, user.m_20182_(), amount, damage, knockup, yaw, 1.0f, 1.85f);
    }

    @Override
    public boolean m_7579_(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        if (!this.isDisabled(stack)) {
            this.addCharge(stack, this.getAddedCharge(stack));
        }
        return super.m_7579_(stack, target, attacker);
    }

    private float getAbilityDamage() {
        return ConfigConstructor.holy_moonlight_ability_damage;
    }

    private float getKnockup(ItemStack stack) {
        return ConfigConstructor.holy_moonlight_ability_knockup + (float)WeaponUtil.getEnchantDamageBonus(stack) / 10.0f;
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (this.isDisabled(itemStack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        if (itemStack.m_41773_() < itemStack.m_41776_() - 1 && (this.isCharged(itemStack) || user.m_7500_() || user.m_21023_((MobEffect)EffectRegistry.MOON_HERALD.get()))) {
            user.m_6672_(hand);
            return InteractionResultHolder.m_19090_((Object)itemStack);
        }
        return InteractionResultHolder.m_19100_((Object)itemStack);
    }

    public UseAnim m_6164_(ItemStack stack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(ItemStack stack) {
        return 72000;
    }

    @Override
    public int getMaxCharge() {
        return ConfigConstructor.holy_moonlight_ability_charge_needed;
    }

    @Override
    public int getAddedCharge(ItemStack stack) {
        int base = ConfigConstructor.holy_moonlight_greatsword_charge_added_post_hit;
        return base + WeaponUtil.getEnchantDamageBonus(stack) * 2;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return ConfigConstructor.holy_moonlight_ability_enchant_reduces_cooldown;
    }

    @Override
    public String getReduceCooldownEnchantId(ItemStack stack) {
        return ConfigConstructor.holy_moonlight_ability_enchant_reduces_cooldown_id;
    }
}

