/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import java.util.List;
import java.util.function.Predicate;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.projectile.SilverBulletEntity;
import net.soulsweaponry.items.IConfigDisable;
import net.soulsweaponry.registry.EnchantRegistry;
import net.soulsweaponry.registry.GunRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import org.jetbrains.annotations.Nullable;

public abstract class GunItem
extends BowItem
implements IConfigDisable {
    public static final Predicate<ItemStack> SILVER_PROJECTILE = stack -> stack.m_150930_((Item)ItemRegistry.SILVER_BULLET.get());

    public GunItem(Item.Properties settings) {
        super(settings);
    }

    public Predicate<ItemStack> m_6437_() {
        return SILVER_PROJECTILE;
    }

    public int getReducedCooldown(ItemStack stack) {
        return EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.FAST_HANDS, (ItemStack)stack) * 8;
    }

    public abstract int getPostureLoss(ItemStack var1);

    public abstract float getBulletDamage(ItemStack var1);

    public abstract float getBulletVelocity(ItemStack var1);

    public abstract float getBulletDivergence(ItemStack var1);

    public abstract int getCooldown(ItemStack var1);

    public abstract int bulletsNeeded();

    public abstract boolean m_41475_();

    public int m_8105_(ItemStack stack) {
        return 0;
    }

    public AbstractArrow createSilverBulletEntity(Level world, LivingEntity shooter, ItemStack gunStack) {
        float power = this.getBulletDamage(gunStack) / this.getBulletVelocity(gunStack) + (float)EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44988_, (ItemStack)gunStack) / 2.0f;
        int punch = EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44989_, (ItemStack)gunStack);
        SilverBulletEntity entity = this.getModdedProjectile(world, shooter, gunStack);
        if (gunStack.m_150930_((Item)GunRegistry.GATLING_GUN.get())) {
            entity.m_20343_(shooter.m_20185_(), shooter.m_20188_() - (double)0.2f, shooter.m_20189_());
        } else {
            entity.m_20343_(shooter.m_20185_(), shooter.m_20188_(), shooter.m_20189_());
        }
        entity.m_37251_((Entity)shooter, shooter.m_146909_(), shooter.m_146908_(), 0.0f, this.getBulletVelocity(gunStack), this.getBulletDivergence(gunStack));
        entity.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
        entity.setPostureLoss(this.getPostureLoss(gunStack));
        entity.m_36781_(power);
        if (punch > 0) {
            entity.m_36735_(punch);
        }
        if (EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44990_, (ItemStack)gunStack) > 0) {
            entity.m_20254_(8);
        }
        return entity;
    }

    public SilverBulletEntity getModdedProjectile(Level world, LivingEntity shooter, ItemStack gunStack) {
        return new SilverBulletEntity(world, shooter);
    }

    public void m_7373_(ItemStack stack, @Nullable Level world, List<Component> tooltip, TooltipFlag context) {
        if (this.isDisabled(stack)) {
            tooltip.add((Component)Component.m_264568_((String)"tooltip.soulsweapons.disabled", (String)"Disabled"));
        }
        if (Screen.m_96638_()) {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.gun_posture_loss").m_7220_((Component)Component.m_237113_((String)String.valueOf(this.getPostureLoss(stack)))).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237110_((String)"tooltip.soulsweapons.gun_posture_loss_on_players", (Object[])new Object[]{Mth.m_14143_((float)(ConfigConstructor.silver_bullet_posture_loss_on_player_modifier * 100.0f)) + "%"}).m_130940_(ChatFormatting.DARK_GRAY));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.gun_damage").m_7220_((Component)Component.m_237113_((String)String.format("%.1f", Float.valueOf(this.getBulletDamage(stack))))).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.gun_cooldown").m_7220_((Component)Component.m_237113_((String)String.valueOf(this.getCooldown(stack)))).m_130940_(ChatFormatting.GRAY));
            tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.gun_bullets_used").m_7220_((Component)Component.m_237113_((String)String.valueOf(this.bulletsNeeded()))).m_130940_(ChatFormatting.GRAY));
            if (this.m_8105_(stack) != 0) {
                tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.gun_max_use_time").m_7220_((Component)Component.m_237113_((String)String.valueOf(this.m_8105_(stack)))).m_130940_(ChatFormatting.GRAY));
            }
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.soulsweapons.shift"));
        }
        super.m_7373_(stack, world, tooltip, context);
    }
}

