/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.GunItem;
import net.soulsweaponry.registry.EnchantRegistry;
import net.soulsweaponry.registry.ItemRegistry;
import net.soulsweaponry.registry.SoundRegistry;

public class GatlingGun
extends GunItem {
    public GatlingGun(Item.Properties settings) {
        super(settings);
    }

    @Override
    public int getPostureLoss(ItemStack stack) {
        int lvl = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.VISCERAL, (ItemStack)stack);
        return ConfigConstructor.gatling_gun_posture_loss + lvl;
    }

    @Override
    public float getBulletDamage(ItemStack stack) {
        return ConfigConstructor.gatling_gun_damage;
    }

    @Override
    public float getBulletVelocity(ItemStack stack) {
        return ConfigConstructor.gatling_gun_velocity;
    }

    @Override
    public float getBulletDivergence(ItemStack stack) {
        return ConfigConstructor.gatling_gun_divergence;
    }

    @Override
    public int getCooldown(ItemStack stack) {
        return ConfigConstructor.gatling_gun_cooldown - 3 * this.getReducedCooldown(stack) + EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) * 30;
    }

    @Override
    public int bulletsNeeded() {
        return ConfigConstructor.gatling_gun_bullets_needed;
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_gatling_gun;
    }

    public void m_5929_(Level world, LivingEntity user, ItemStack stack, int remainingUseTicks) {
        if (remainingUseTicks < this.m_8105_(stack) - 15 && remainingUseTicks % 4 == 0) {
            if (user instanceof Player) {
                Player playerEntity = (Player)user;
                boolean bl = playerEntity.m_150110_().f_35937_ || EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44952_, (ItemStack)stack) > 0;
                ItemStack itemStack = playerEntity.m_6298_(stack);
                if (!itemStack.m_41619_() || bl) {
                    if (itemStack.m_41619_()) {
                        itemStack = new ItemStack((ItemLike)ItemRegistry.SILVER_BULLET.get());
                    }
                    boolean bl2 = bl && itemStack.m_150930_((Item)ItemRegistry.SILVER_BULLET.get());
                    Vec3 pov = playerEntity.m_20154_();
                    Vec3 particleBox = pov.m_82490_(1.0).m_82549_(playerEntity.m_20182_());
                    if (world.f_46443_) {
                        for (int k = 0; k < 8 + EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.FAST_HANDS, (ItemStack)stack); ++k) {
                            world.m_6493_((ParticleOptions)ParticleTypes.f_123744_, true, particleBox.f_82479_, particleBox.f_82480_ + 1.5, particleBox.f_82481_, pov.f_82479_ + user.m_217043_().m_188500_() - 0.25, pov.f_82480_ + user.m_217043_().m_188500_() - 0.5, pov.f_82481_ + user.m_217043_().m_188500_() - 0.25);
                            world.m_6493_((ParticleOptions)ParticleTypes.f_123762_, true, particleBox.f_82479_, particleBox.f_82480_ + 1.5, particleBox.f_82481_, pov.f_82479_ + user.m_217043_().m_188500_() - 0.25, pov.f_82480_ + user.m_217043_().m_188500_() - 0.5, pov.f_82481_ + user.m_217043_().m_188500_() - 0.25);
                        }
                    }
                    AbstractArrow entity = this.createSilverBulletEntity(world, user, stack);
                    world.m_7967_((Entity)entity);
                    world.m_5594_(playerEntity, user.m_20183_(), (SoundEvent)SoundRegistry.GATLING_GUN_BARRAGE_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!bl2 && !playerEntity.m_150110_().f_35937_) {
                        itemStack.m_41774_(this.bulletsNeeded());
                        if (itemStack.m_41619_()) {
                            playerEntity.m_150109_().m_36057_(itemStack);
                        }
                    }
                    playerEntity.m_36246_(Stats.f_12982_.m_12902_((Object)this));
                }
            }
        } else if (-remainingUseTicks > this.m_8105_(stack)) {
            user.m_21253_();
            super.m_5929_(world, user, stack, remainingUseTicks);
        }
    }

    public ItemStack m_5922_(ItemStack stack, Level world, LivingEntity user) {
        this.stop(user, stack, world);
        return super.m_5922_(stack, world, user);
    }

    @Override
    public int m_8105_(ItemStack stack) {
        int lvl = EnchantmentHelper.m_44843_((Enchantment)EnchantRegistry.FAST_HANDS, (ItemStack)stack);
        return ConfigConstructor.gatling_gun_max_time * (lvl == 0 ? 1 : lvl);
    }

    public void m_5551_(ItemStack stack, Level world, LivingEntity user, int remainingUseTicks) {
        this.stop(user, stack, world);
    }

    private void stop(LivingEntity user, ItemStack stack, Level world) {
        world.m_5594_(null, user.m_20183_(), (SoundEvent)SoundRegistry.GATLING_GUN_STOP_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (user instanceof Player) {
            Player player = (Player)user;
            player.m_36335_().m_41524_((Item)this, this.getCooldown(stack));
            stack.m_41622_(5, (LivingEntity)player, p_220045_0_ -> p_220045_0_.m_21190_(user.m_7655_()));
        }
    }

    public InteractionResultHolder<ItemStack> m_7203_(Level world, Player user, InteractionHand hand) {
        ItemStack itemStack = user.m_21120_(hand);
        if (this.isDisabled(itemStack)) {
            this.notifyDisabled((LivingEntity)user);
            return InteractionResultHolder.m_19100_((Object)user.m_21120_(hand));
        }
        world.m_5594_(user, user.m_20183_(), (SoundEvent)SoundRegistry.GATLING_GUN_STARTUP_EVENT.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
        if (itemStack.m_41773_() >= itemStack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemStack);
        }
        user.m_6672_(hand);
        return InteractionResultHolder.m_19096_((Object)itemStack);
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_gatling_gun;
    }
}

