/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.items;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.level.Level;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.items.ModdedSword;
import net.soulsweaponry.util.WeaponUtil;

public class Draugr
extends ModdedSword {
    public static final String NIGHT = "night";

    public Draugr(Tier toolMaterial, Item.Properties settings) {
        super(toolMaterial, 1, ConfigConstructor.draugr_attack_speed, settings);
        this.addTooltipAbility(WeaponUtil.TooltipAbilities.NIGHT_PROWLER);
    }

    public void m_6883_(ItemStack stack, Level world, Entity entity, int slot, boolean selected) {
        super.m_6883_(stack, world, entity, slot, selected);
        this.refreshDayTime(world, stack);
    }

    private void refreshDayTime(Level world, ItemStack stack) {
        if (stack.m_41782_() && !world.f_46443_) {
            stack.m_41783_().m_128379_(NIGHT, world.m_6042_().f_223549_() && world.m_46462_());
        }
    }

    private boolean isNight(ItemStack stack) {
        if (stack.m_41782_() && stack.m_41783_().m_128441_(NIGHT)) {
            return stack.m_41783_().m_128471_(NIGHT);
        }
        return false;
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        if (slot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", this.isNight(stack) && !this.isDisabled(stack) ? (double)(ConfigConstructor.draugr_damage_at_night - 1) : 0.0, AttributeModifier.Operation.ADDITION));
            builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)this.getAttackSpeed(), AttributeModifier.Operation.ADDITION));
            ImmutableMultimap attributeModifiers = builder.build();
            return attributeModifiers;
        }
        return super.getAttributeModifiers(slot, stack);
    }

    @Override
    public boolean m_41475_() {
        return ConfigConstructor.is_fireproof_draugr;
    }

    @Override
    public boolean isDisabled(ItemStack stack) {
        return ConfigConstructor.disable_use_draugr;
    }

    @Override
    public boolean canEnchantReduceCooldown(ItemStack stack) {
        return false;
    }

    @Override
    public String getReduceCooldownEnchantId(ItemStack stack) {
        return null;
    }
}

