/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entitydata.posture;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.LivingEntity;
import net.soulsweaponry.networking.ModMessages;
import net.soulsweaponry.networking.packets.S2C.PostureSyncS2C;

public class PostureData {
    public static final String POSTURE_ID = "posture";

    public static int addPosture(LivingEntity entity, int amount) {
        int posture;
        CompoundTag nbt = entity.getPersistentData();
        if (!nbt.m_128441_(POSTURE_ID)) {
            nbt.m_128405_(POSTURE_ID, 0);
        }
        posture = (posture = nbt.m_128451_(POSTURE_ID)) < 0 ? 0 : (posture += amount);
        nbt.m_128405_(POSTURE_ID, posture);
        if (entity instanceof ServerPlayer) {
            PostureData.syncData(posture, (ServerPlayer)entity);
        }
        return posture;
    }

    public static int getPosture(LivingEntity entity) {
        if (!entity.getPersistentData().m_128441_(POSTURE_ID)) {
            entity.getPersistentData().m_128405_(POSTURE_ID, 0);
        }
        return entity.getPersistentData().m_128451_(POSTURE_ID);
    }

    public static int reducePosture(LivingEntity entity, int amount) {
        return PostureData.addPosture(entity, -amount);
    }

    public static int setPosture(LivingEntity entity, int amount) {
        CompoundTag nbt = entity.getPersistentData();
        nbt.m_128405_(POSTURE_ID, amount);
        if (entity instanceof ServerPlayer) {
            PostureData.syncData(amount, (ServerPlayer)entity);
        }
        return amount;
    }

    public static void syncData(int posture, ServerPlayer entity) {
        ModMessages.sendToPlayer(new PostureSyncS2C(posture), entity);
    }
}

