/*
 * Decompiled with CFR 0.152.
 */
package net.soulsweaponry.entity.util;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.soulsweaponry.config.ConfigConstructor;
import net.soulsweaponry.entity.mobs.NightProwler;
import net.soulsweaponry.particles.ParticleEvents;
import net.soulsweaponry.particles.ParticleHandler;
import org.jetbrains.annotations.Nullable;

public class BlackflameSnakeLogic {
    private final Vec3 start;
    private final Vec3 end;
    private final float radius;
    private final int ticksBetween;
    private final float yaw;
    private final UUID ownerUuid;
    private int age;
    private final List<List<Vec3>> allPos = new ArrayList<List<Vec3>>();

    public BlackflameSnakeLogic(Vec3 start, Vec3 end, float radius, int ticksBetween, float userYaw, UUID ownerUuid) {
        this.start = start;
        this.end = end;
        this.radius = radius;
        this.ticksBetween = ticksBetween;
        this.yaw = userYaw;
        this.ownerUuid = ownerUuid;
        this.allPos.add(this.getPositionsFromSide(true));
        this.allPos.add(this.getPositionsFromSide(false));
    }

    public void tick(Level world) {
        ++this.age;
        for (List<Vec3> list : this.allPos) {
            if (this.age % this.ticksBetween != 0 || list.size() == 0) continue;
            this.ruptureLogic(world, list.get(0));
            list.remove(0);
        }
    }

    private void ruptureLogic(Level world, Vec3 target) {
        if (!world.f_46443_) {
            ParticleHandler.particleOutburstMap(world, 250, target.m_7096_(), target.m_7098_(), target.m_7094_(), ParticleEvents.BLACKFLAME_SNAKE_PARTICLE_MAP, 1.0f);
            for (Entity entity : world.m_45933_(this.getOwner(world), new AABB(BlockPos.m_274446_((Position)target)).m_82400_(2.0))) {
                DamageSource src;
                LivingEntity living;
                if (!(entity instanceof LivingEntity) || this.isOwner(living = (LivingEntity)entity) || entity instanceof NightProwler || !living.m_6469_(src = this.getOwner(world) != null && this.getOwner(world) instanceof LivingEntity ? world.m_269111_().m_269333_((LivingEntity)this.getOwner(world)) : world.m_269111_().m_269264_(), 35.0f * ConfigConstructor.night_prowler_damage_modifier)) continue;
                living.m_5997_(0.0, 1.0, 0.0);
            }
            world.m_5594_(null, BlockPos.m_274446_((Position)target), SoundEvents.f_11913_, SoundSource.HOSTILE, 1.0f, 1.0f);
        }
    }

    private List<Vec3> calcAllPositions() {
        ArrayList<Vec3> positions = new ArrayList<Vec3>();
        double yaw = this.yaw + 90.0f;
        double ra = Math.toRadians(yaw);
        float r = this.radius;
        Vec3 s = this.start.m_82520_(Math.cos(ra) * (double)r, 0.0, Math.sin(ra) * (double)r);
        Vec3 endLeft = null;
        Vec3 endRight = null;
        for (int i = 90; i < 270; ++i) {
            if (i % 8 != 0) continue;
            double rad = Math.toRadians(yaw + (double)i);
            double x = (double)r * Math.cos(rad);
            double z = (double)r * Math.sin(rad);
            Vec3 pos = new Vec3(x, 0.0, z).m_82549_(s);
            if (i == 264) {
                endLeft = pos;
            }
            if (i == 96) {
                endRight = pos;
            }
            positions.add(pos);
        }
        if (endLeft != null && endRight != null) {
            Vec3 start = endLeft;
            Vec3 between = new Vec3(this.end.m_7096_() - start.m_7096_(), this.end.m_7098_() - start.m_7098_(), this.end.m_7094_() - start.m_7094_());
            int len = Mth.m_14107_((double)between.m_82553_());
            for (int i = 0; i < len; ++i) {
                start = start.m_82549_(between.m_82490_(1.0 / (double)len));
                positions.add(new Vec3(start.m_7096_(), start.m_7098_(), start.m_7094_()));
            }
            Vec3 start2 = endRight;
            Vec3 between2 = new Vec3(this.end.m_7096_() - start2.m_7096_(), this.end.m_7098_() - start2.m_7098_(), this.end.m_7094_() - start2.m_7094_());
            int len2 = Mth.m_14107_((double)between2.m_82553_());
            for (int i = 0; i < len2; ++i) {
                start2 = start2.m_82549_(between2.m_82490_(1.0 / (double)len));
                positions.add(new Vec3(start2.m_7096_(), start2.m_7098_(), start2.m_7094_()));
            }
        }
        return positions;
    }

    private List<Vec3> getPositionsFromSide(boolean leftSide) {
        ArrayList<Vec3> positions = new ArrayList<Vec3>();
        double yaw = this.yaw + 90.0f;
        double ra = Math.toRadians(yaw);
        float r = this.radius;
        Vec3 s = this.start.m_82520_(Math.cos(ra) * (double)r, 0.0, Math.sin(ra) * (double)r);
        Vec3 endPos = null;
        int i = 180;
        while (leftSide ? i < 270 : i > 90) {
            if (i % 8 == 0) {
                double rad = Math.toRadians(yaw + (double)i);
                double x = (double)r * Math.cos(rad);
                double z = (double)r * Math.sin(rad);
                Vec3 pos = new Vec3(x, 0.0, z).m_82549_(s);
                if (i == (leftSide ? 264 : 96)) {
                    endPos = pos;
                }
                positions.add(pos);
            }
            if (leftSide) {
                ++i;
                continue;
            }
            --i;
        }
        if (endPos != null) {
            positions.addAll(this.getPosOfLine(endPos));
        }
        return positions;
    }

    private List<Vec3> getPosOfLine(Vec3 targetPos) {
        ArrayList<Vec3> positions = new ArrayList<Vec3>();
        Vec3 between = new Vec3(this.end.m_7096_() - targetPos.m_7096_(), this.end.m_7098_() - targetPos.m_7098_(), this.end.m_7094_() - targetPos.m_7094_());
        int len = Mth.m_14107_((double)between.m_82553_());
        for (int j = 0; j < len; ++j) {
            targetPos = targetPos.m_82549_(between.m_82490_(1.0 / (double)len));
            positions.add(new Vec3(targetPos.m_7096_(), targetPos.m_7098_(), targetPos.m_7094_()));
        }
        return positions;
    }

    public Vec3 getStart() {
        return this.start;
    }

    public Vec3 getEnd() {
        return this.end;
    }

    public float getRadius() {
        return this.radius;
    }

    public float getYaw() {
        return this.yaw;
    }

    public int getTicksBetween() {
        return this.ticksBetween;
    }

    public UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    public boolean isOwner(LivingEntity target) {
        return target.m_20148_().equals(this.ownerUuid);
    }

    public boolean isFinished() {
        int i = 0;
        for (List<Vec3> list : this.allPos) {
            i += list.size();
        }
        return i == 0;
    }

    @Nullable
    public Entity getOwner(Level world) {
        if (!world.f_46443_) {
            return ((ServerLevel)world).m_8791_(this.getOwnerUuid());
        }
        return null;
    }
}

